/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.NullOwner;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.change.NodeDetachChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class StateNode
implements Serializable {
    private static final Map<Set<Class<? extends NodeFeature>>, Set<Class<? extends NodeFeature>>> nodeFeatureSetCache = new ConcurrentHashMap<Set<Class<? extends NodeFeature>>, Set<Class<? extends NodeFeature>>>();
    private final Map<Class<? extends NodeFeature>, NodeFeature> features = new HashMap<Class<? extends NodeFeature>, NodeFeature>();
    private final Set<Class<? extends NodeFeature>> reportedFeatures;
    private Map<Class<? extends NodeFeature>, Serializable> changes;
    private List<Command> attachListeners;
    private List<Command> detachListeners;
    private NodeOwner owner = NullOwner.get();
    private StateNode parent;
    private int id = -1;
    private boolean wasAttached = this.isAttached();
    private boolean isInactiveSelf;
    private boolean isInitialChanges = true;
    private ArrayList<StateTree.BeforeClientResponseEntry> beforeClientResponseEntries;
    private boolean enabled = true;

    @SafeVarargs
    public StateNode(Class<? extends NodeFeature> ... featureTypes) {
        this(Collections.emptyList(), featureTypes);
    }

    public StateNode(StateNode node) {
        this(new ArrayList<Class<? extends NodeFeature>>(node.reportedFeatures), StateNode.getNonRepeatebleFeatures(node));
    }

    @SafeVarargs
    public StateNode(List<Class<? extends NodeFeature>> reportableFeatureTypes, Class<? extends NodeFeature> ... nonReportableFeatureTypes) {
        this.reportedFeatures = StateNode.getCachedFeatureSet(reportableFeatureTypes);
        Stream.concat(reportableFeatureTypes.stream(), Stream.of(nonReportableFeatureTypes)).forEach(this::addFeature);
    }

    private static Set<Class<? extends NodeFeature>> getCachedFeatureSet(Collection<Class<? extends NodeFeature>> reportableFeatureTypes) {
        Set<Class<? extends NodeFeature>> keyAndValue = Collections.unmodifiableSet(new HashSet<Class<? extends NodeFeature>>(reportableFeatureTypes));
        Set<Class<? extends NodeFeature>> currentValue = nodeFeatureSetCache.putIfAbsent(keyAndValue, keyAndValue);
        if (currentValue == null) {
            return keyAndValue;
        }
        return currentValue;
    }

    public NodeOwner getOwner() {
        return this.owner;
    }

    public StateNode getParent() {
        return this.parent;
    }

    public void setParent(StateNode parent) {
        if (this.hasDetached()) {
            return;
        }
        boolean attachedBefore = this.isAttached();
        boolean attachedAfter = false;
        if (parent != null) {
            assert (this.parent == null) : "Node is already attached to a parent: " + this.parent;
            assert (parent.hasChildAssert(this));
            if (this.isAncestorOf(parent)) {
                throw new IllegalStateException("Can't set own child as parent");
            }
            attachedAfter = parent.isAttached();
            NodeOwner parentOwner = parent.getOwner();
            if (parentOwner != this.owner && parentOwner instanceof StateTree) {
                this.setTree((StateTree)parentOwner);
            }
        }
        if (!attachedBefore && attachedAfter) {
            this.parent = parent;
            this.onAttach();
        } else if (attachedBefore && !attachedAfter) {
            this.onDetach();
            this.parent = parent;
        } else {
            this.parent = parent;
        }
    }

    private boolean hasDetached() {
        return this.isAttached() && !this.owner.hasNode(this);
    }

    private boolean isAncestorOf(StateNode node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private boolean hasChildAssert(StateNode child) {
        AtomicBoolean found = new AtomicBoolean(false);
        this.forEachChild(c -> {
            if (c == child) {
                found.set(true);
            }
        });
        return found.get();
    }

    protected void onAttach() {
        this.visitNodeTreeBottomUp(StateNode::handleOnAttach);
    }

    private void onDetach() {
        this.visitNodeTreeBottomUp(StateNode::handleOnDetach);
    }

    private void forEachChild(Consumer<StateNode> action) {
        this.getFeatures().values().forEach(n -> n.forEachChild(action));
    }

    protected void setTree(StateTree tree) {
        this.visitNodeTree(node -> node.doSetTree(tree));
    }

    public <T extends NodeFeature> T getFeature(Class<T> featureType) {
        assert (featureType != null);
        NodeFeature feature = this.getFeatures().get(featureType);
        if (feature == null) {
            throw new IllegalStateException("Node does not have the feature " + featureType);
        }
        return (T)((NodeFeature)featureType.cast(feature));
    }

    public boolean hasFeature(Class<? extends NodeFeature> featureType) {
        assert (featureType != null);
        return this.getFeatures().containsKey(featureType);
    }

    public int getId() {
        return this.id;
    }

    public void markAsDirty() {
        this.owner.markAsDirty(this);
    }

    public boolean isAttached() {
        return this.parent != null && this.parent.isAttached();
    }

    boolean isClientSideInitialized() {
        return this.wasAttached;
    }

    public void collectChanges(Consumer<NodeChange> collector) {
        boolean isAttached = this.isAttached();
        if (isAttached != this.wasAttached) {
            if (isAttached) {
                collector.accept(new NodeAttachChange(this));
                this.clearChanges();
                this.getFeatures().values().forEach(NodeFeature::generateChangesFromEmpty);
            } else {
                collector.accept(new NodeDetachChange(this));
            }
            this.wasAttached = isAttached;
        }
        if (!this.isAttached()) {
            return;
        }
        if (this.isInactive()) {
            if (this.isInitialChanges) {
                Stream<NodeFeature> initialFeatures = Stream.concat(this.getFeatures().entrySet().stream().filter(entry -> this.isReportedFeature((Class)entry.getKey())).map(Map.Entry::getValue), this.getDisalowFeatures());
                this.doCollectChanges(collector, initialFeatures);
            } else {
                this.doCollectChanges(collector, this.getDisalowFeatures());
            }
        } else {
            this.doCollectChanges(collector, this.getFeatures().values().stream());
        }
    }

    private void doCollectChanges(Consumer<NodeChange> collector, Stream<NodeFeature> features) {
        features.filter(this::hasChangeTracker).forEach(feature -> {
            feature.collectChanges(collector);
            this.changes.remove(feature.getClass());
        });
        this.isInitialChanges = false;
        if (this.changes != null && this.changes.isEmpty()) {
            this.changes = null;
        }
    }

    private boolean hasChangeTracker(NodeFeature nodeFeature) {
        return this.changes != null && this.changes.containsKey(nodeFeature.getClass());
    }

    public void clearChanges() {
        this.changes = null;
    }

    public void visitNodeTree(Consumer<StateNode> visitor) {
        LinkedList<StateNode> stack = new LinkedList<StateNode>();
        stack.add(this);
        while (!stack.isEmpty()) {
            StateNode node = (StateNode)stack.removeFirst();
            visitor.accept(node);
            node.forEachChild(child -> stack.add(0, (StateNode)child));
        }
    }

    void visitNodeTreeBottomUp(Consumer<StateNode> visitor) {
        LinkedList<StateNode> stack = new LinkedList<StateNode>();
        stack.add(this);
        this.forEachChild(stack::addFirst);
        StateNode previousParent = this;
        while (!stack.isEmpty()) {
            StateNode current = (StateNode)stack.getFirst();
            assert (current != null);
            if (current == previousParent) {
                visitor.accept((StateNode)stack.removeFirst());
                previousParent = current.getParent();
                continue;
            }
            current.forEachChild(stack::addFirst);
            previousParent = current;
        }
    }

    private void doSetTree(StateTree tree) {
        if (tree == this.owner) {
            return;
        }
        if (this.owner instanceof StateTree) {
            throw new IllegalStateException("Can't move a node from one state tree to another");
        }
        this.owner = tree;
    }

    private void handleOnAttach() {
        assert (this.isAttached());
        boolean initialAttach = false;
        int newId = this.owner.register(this);
        if (newId != -1) {
            if (this.id == -1) {
                this.id = newId;
                initialAttach = true;
            } else if (newId != this.id) {
                throw new IllegalStateException("Can't change id once it has been assigned");
            }
        }
        this.markAsDirty();
        this.fireAttachListeners(initialAttach);
    }

    private void handleOnDetach() {
        assert (this.isAttached());
        this.markAsDirty();
        this.owner.unregister(this);
        this.fireDetachListeners();
    }

    public Registration addAttachListener(Command attachListener) {
        assert (attachListener != null);
        if (this.attachListeners == null) {
            this.attachListeners = new ArrayList<Command>(1);
        }
        this.attachListeners.add(attachListener);
        return () -> this.removeAttachListener(attachListener);
    }

    public Registration addDetachListener(Command detachListener) {
        assert (detachListener != null);
        if (this.detachListeners == null) {
            this.detachListeners = new ArrayList<Command>(1);
        }
        this.detachListeners.add(detachListener);
        return () -> this.removeDetachListener(detachListener);
    }

    private void removeAttachListener(Command attachListener) {
        assert (attachListener != null);
        this.attachListeners.remove(attachListener);
        if (this.attachListeners.isEmpty()) {
            this.attachListeners = null;
        }
    }

    private void removeDetachListener(Command detachListener) {
        assert (detachListener != null);
        this.detachListeners.remove(detachListener);
        if (this.detachListeners.isEmpty()) {
            this.detachListeners = null;
        }
    }

    private void fireAttachListeners(boolean initialAttach) {
        if (this.attachListeners != null) {
            ArrayList<Command> copy = new ArrayList<Command>(this.attachListeners);
            copy.forEach(Command::execute);
        }
        this.getFeatures().values().forEach(f -> f.onAttach(initialAttach));
    }

    private void fireDetachListeners() {
        if (this.detachListeners != null) {
            ArrayList<Command> copy = new ArrayList<Command>(this.detachListeners);
            copy.forEach(Command::execute);
        }
        this.getFeatures().values().forEach(NodeFeature::onDetach);
    }

    public <T extends Serializable> T getChangeTracker(NodeFeature feature, Supplier<T> factory) {
        if (this.changes == null) {
            this.changes = new HashMap<Class<? extends NodeFeature>, Serializable>();
        }
        return (T)this.changes.computeIfAbsent(feature.getClass(), k -> (Serializable)factory.get());
    }

    public void runWhenAttached(final SerializableConsumer<UI> command) {
        if (this.isAttached()) {
            command.accept(this.getUI());
        } else {
            this.addAttachListener(new Command(){

                @Override
                public void execute() {
                    command.accept(StateNode.this.getUI());
                    StateNode.this.removeAttachListener(this);
                }
            });
        }
    }

    public boolean isReportedFeature(Class<? extends NodeFeature> featureType) {
        return this.reportedFeatures.contains(featureType);
    }

    public void updateActiveState() {
        this.setInactive(this.getDisalowFeatures().count() != 0L);
    }

    public boolean isInactive() {
        if (this.isInactiveSelf || this.getParent() == null) {
            return this.isInactiveSelf;
        }
        return this.getParent().isInactive();
    }

    private Stream<NodeFeature> getDisalowFeatures() {
        return this.getFeatures().values().stream().filter(feature -> !feature.allowsChanges());
    }

    private void setInactive(boolean inactive) {
        if (this.isInactiveSelf != inactive) {
            this.isInactiveSelf = inactive;
            this.visitNodeTree(child -> {
                if (!this.equals(child) && !child.isInactiveSelf) {
                    child.markAsDirty();
                }
            });
        }
    }

    private UI getUI() {
        assert (this.isAttached());
        assert (this.getOwner() instanceof StateTree) : "Attach should only be called when the node has been attached to the tree, not to a null owner";
        return ((StateTree)this.getOwner()).getUI();
    }

    private void addFeature(Class<? extends NodeFeature> featureType) {
        if (!this.features.containsKey(featureType)) {
            NodeFeature feature = NodeFeatureRegistry.create(featureType, this);
            this.features.put(featureType, feature);
        }
    }

    private Map<Class<? extends NodeFeature>, NodeFeature> getFeatures() {
        return this.features;
    }

    private static Class[] getNonRepeatebleFeatures(StateNode node) {
        if (node.reportedFeatures.isEmpty()) {
            Set<Class<? extends NodeFeature>> set = node.features.keySet();
            return set.toArray(new Class[set.size()]);
        }
        return (Class[])node.features.keySet().stream().filter(clazz -> !node.reportedFeatures.contains(clazz)).toArray(Class[]::new);
    }

    public boolean hasBeforeClientResponseEntries() {
        return this.beforeClientResponseEntries != null;
    }

    public List<StateTree.BeforeClientResponseEntry> dumpBeforeClientResponseEntries() {
        ArrayList<StateTree.BeforeClientResponseEntry> entries = this.beforeClientResponseEntries;
        this.beforeClientResponseEntries = null;
        return !entries.isEmpty() ? entries : Collections.emptyList();
    }

    public StateTree.ExecutionRegistration addBeforeClientResponseEntry(StateTree.BeforeClientResponseEntry entry) {
        assert (entry != null);
        if (this.beforeClientResponseEntries == null) {
            this.beforeClientResponseEntries = new ArrayList();
        }
        ArrayList<StateTree.BeforeClientResponseEntry> localEntries = this.beforeClientResponseEntries;
        localEntries.add(entry);
        return () -> localEntries.remove(entry);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        boolean isEnabledSelf = this.isEnabledSelf();
        if (this.getParent() != null && isEnabledSelf) {
            return this.getParent().isEnabled();
        }
        return isEnabledSelf;
    }

    public boolean isEnabledSelf() {
        return this.enabled;
    }
}

