/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.internal.nodefeature.BasicTypeValue;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PolymerEventListenerMap;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ShadowRootData;
import com.vaadin.flow.internal.nodefeature.ShadowRootHost;
import com.vaadin.flow.internal.nodefeature.SynchronizedPropertiesList;
import com.vaadin.flow.internal.nodefeature.SynchronizedPropertyEventsList;
import com.vaadin.flow.internal.nodefeature.TextNodeMap;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NodeFeatureRegistry {
    private static int nextNodeFeatureId = 0;
    static final Map<Class<? extends NodeFeature>, NodeFeatureData> nodeFeatures = new HashMap<Class<? extends NodeFeature>, NodeFeatureData>();
    private static final Map<Integer, Class<? extends NodeFeature>> idToFeature = new HashMap<Integer, Class<? extends NodeFeature>>();

    private NodeFeatureRegistry() {
    }

    private static <T extends NodeFeature> void registerFeature(Class<T> type, SerializableFunction<StateNode, T> factory) {
        NodeFeatureData featureData = new NodeFeatureData(factory);
        nodeFeatures.put(type, featureData);
        idToFeature.put(featureData.id, type);
    }

    public static NodeFeature create(Class<? extends NodeFeature> nodeFeatureType, StateNode node) {
        assert (node != null);
        return (NodeFeature)NodeFeatureRegistry.getData(nodeFeatureType).factory.apply(node);
    }

    public static int getId(Class<? extends NodeFeature> nodeFeature) {
        return NodeFeatureRegistry.getData(nodeFeature).id;
    }

    public static Collection<Class<? extends NodeFeature>> getFeatures() {
        return Collections.unmodifiableCollection(nodeFeatures.keySet());
    }

    private static NodeFeatureData getData(Class<? extends NodeFeature> nodeFeature) {
        assert (nodeFeature != null);
        NodeFeatureData data = nodeFeatures.get(nodeFeature);
        assert (data != null) : "Feature " + nodeFeature.getName() + " has not been registered in NodeFeatureRegistry";
        return data;
    }

    public static Class<? extends NodeFeature> getFeature(int featureId) {
        return idToFeature.get(featureId);
    }

    static {
        NodeFeatureRegistry.registerFeature(ElementData.class, ElementData::new);
        NodeFeatureRegistry.registerFeature(ElementPropertyMap.class, ElementPropertyMap::new);
        NodeFeatureRegistry.registerFeature(ElementChildrenList.class, ElementChildrenList::new);
        NodeFeatureRegistry.registerFeature(ElementAttributeMap.class, ElementAttributeMap::new);
        NodeFeatureRegistry.registerFeature(ElementListenerMap.class, ElementListenerMap::new);
        NodeFeatureRegistry.registerFeature(PushConfigurationMap.class, PushConfigurationMap::new);
        NodeFeatureRegistry.registerFeature(PushConfigurationMap.PushConfigurationParametersMap.class, PushConfigurationMap.PushConfigurationParametersMap::new);
        NodeFeatureRegistry.registerFeature(TextNodeMap.class, TextNodeMap::new);
        NodeFeatureRegistry.registerFeature(PollConfigurationMap.class, PollConfigurationMap::new);
        NodeFeatureRegistry.registerFeature(ReconnectDialogConfigurationMap.class, ReconnectDialogConfigurationMap::new);
        NodeFeatureRegistry.registerFeature(LoadingIndicatorConfigurationMap.class, LoadingIndicatorConfigurationMap::new);
        NodeFeatureRegistry.registerFeature(ElementClassList.class, ElementClassList::new);
        NodeFeatureRegistry.registerFeature(ElementStylePropertyMap.class, ElementStylePropertyMap::new);
        NodeFeatureRegistry.registerFeature(SynchronizedPropertiesList.class, SynchronizedPropertiesList::new);
        NodeFeatureRegistry.registerFeature(SynchronizedPropertyEventsList.class, SynchronizedPropertyEventsList::new);
        NodeFeatureRegistry.registerFeature(ComponentMapping.class, ComponentMapping::new);
        NodeFeatureRegistry.registerFeature(ModelList.class, ModelList::new);
        NodeFeatureRegistry.registerFeature(PolymerServerEventHandlers.class, PolymerServerEventHandlers::new);
        NodeFeatureRegistry.registerFeature(PolymerEventListenerMap.class, PolymerEventListenerMap::new);
        NodeFeatureRegistry.registerFeature(ClientCallableHandlers.class, ClientCallableHandlers::new);
        NodeFeatureRegistry.registerFeature(ShadowRootData.class, ShadowRootData::new);
        NodeFeatureRegistry.registerFeature(ShadowRootHost.class, ShadowRootHost::new);
        NodeFeatureRegistry.registerFeature(AttachExistingElementFeature.class, AttachExistingElementFeature::new);
        NodeFeatureRegistry.registerFeature(BasicTypeValue.class, BasicTypeValue::new);
        NodeFeatureRegistry.registerFeature(VirtualChildrenList.class, VirtualChildrenList::new);
    }

    private static class NodeFeatureData
    implements Serializable {
        private final SerializableFunction<StateNode, ? extends NodeFeature> factory;
        private final int id;

        private <T extends NodeFeature> NodeFeatureData(SerializableFunction<StateNode, T> factory) {
            this.factory = factory;
            this.id = nextNodeFeatureId++;
        }
    }
}

