/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouterUtil;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import com.vaadin.flow.server.startup.NavigationTargetFilter;
import com.vaadin.flow.server.startup.RouteTarget;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteRegistry
implements Serializable {
    private static final ThemeDefinition LUMO_CLASS_IF_AVAILABLE = RouteRegistry.loadLumoClassIfAvailable();
    private static final Set<Class<? extends Component>> defaultErrorHandlers = Stream.of(RouteNotFoundError.class, InternalServerError.class).collect(Collectors.toSet());
    private final ArrayList<NavigationTargetFilter> routeFilters = new ArrayList();
    private final AtomicReference<Map<String, RouteTarget>> routes = new AtomicReference();
    private final AtomicReference<Map<Class<? extends Component>, String>> targetRoutes = new AtomicReference();
    private final AtomicReference<Map<Class<? extends Exception>, Class<? extends Component>>> exceptionTargets = new AtomicReference();
    private final AtomicReference<List<RouteData>> routeData = new AtomicReference();

    protected RouteRegistry() {
        ServiceLoader.load(NavigationTargetFilter.class).forEach(this.routeFilters::add);
    }

    private static final ThemeDefinition loadLumoClassIfAvailable() {
        try {
            Class<?> theme = Class.forName("com.vaadin.flow.theme.lumo.Lumo");
            return new ThemeDefinition(theme, "");
        }
        catch (ClassNotFoundException e) {
            Logger logger = LoggerFactory.getLogger((String)RouteRegistry.class.getName());
            logger.trace("Lumo theme is not present in the classpath. The application will not use any default theme.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RouteRegistry getInstance(ServletContext servletContext) {
        Object attribute;
        assert (servletContext != null);
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            attribute = servletContext.getAttribute(RouteRegistry.class.getName());
            if (attribute == null) {
                attribute = new RouteRegistry();
                servletContext.setAttribute(RouteRegistry.class.getName(), attribute);
            }
        }
        if (attribute instanceof RouteRegistry) {
            return (RouteRegistry)attribute;
        }
        throw new IllegalStateException("Unknown servlet context attribute value: " + attribute);
    }

    public void setNavigationTargets(Set<Class<? extends Component>> navigationTargets) throws InvalidRouteConfigurationException {
        if (this.navigationTargetsInitialized()) {
            throw new InvalidRouteConfigurationException("Routes have already been initialized");
        }
        this.registerNavigationTargets(navigationTargets);
    }

    public void setErrorNavigationTargets(Set<Class<? extends Component>> errorNavigationTargets) {
        HashMap<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
        errorNavigationTargets.removeAll(defaultErrorHandlers);
        for (Class<? extends Component> target : errorNavigationTargets) {
            if (!this.routeFilters.stream().allMatch(filter -> filter.testErrorNavigationTarget(target))) continue;
            Class<Exception> exceptionType = ReflectTools.getGenericInterfaceType(target, HasErrorParameter.class).asSubclass(Exception.class);
            if (exceptionTargetsMap.containsKey(exceptionType)) {
                this.handleRegisteredExceptionType(exceptionTargetsMap, target, exceptionType);
                continue;
            }
            exceptionTargetsMap.put(exceptionType, target);
        }
        this.initErrorTargets(exceptionTargetsMap);
    }

    public List<RouteData> getRegisteredRoutes() {
        if (this.routeData.get() == null) {
            ArrayList registeredRoutes = new ArrayList();
            Map<Class<? extends Component>, String> targetRouteMap = this.targetRoutes.get();
            if (targetRouteMap != null) {
                targetRouteMap.forEach((target, url) -> {
                    List<Class<?>> parameters = this.getRouteParameters((Class<? extends Component>)target);
                    RouteData route = new RouteData(this.getParentLayout((Class<?>)target), (String)url, parameters, (Class<? extends Component>)target);
                    registeredRoutes.add(route);
                });
            }
            Collections.sort(registeredRoutes);
            this.routeData.compareAndSet(null, Collections.unmodifiableList(registeredRoutes));
        }
        return this.routeData.get();
    }

    private Class<? extends RouterLayout> getParentLayout(Class<?> target) {
        return AnnotationReader.getAnnotationFor(target, Route.class).map(Route::layout).orElse(null);
    }

    private List<Class<?>> getRouteParameters(Class<? extends Component> target) {
        ArrayList parameters = new ArrayList();
        if (HasUrlParameter.class.isAssignableFrom(target)) {
            Class<?> genericInterfaceType = ReflectTools.getGenericInterfaceType(target, HasUrlParameter.class);
            parameters.add(genericInterfaceType);
        }
        return parameters;
    }

    public boolean errorNavigationTargetsInitialized() {
        return this.exceptionTargets.get() != null;
    }

    private void handleRegisteredExceptionType(Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap, Class<? extends Component> target, Class<? extends Exception> exceptionType) {
        Class<? extends Component> registered = exceptionTargetsMap.get(exceptionType);
        if (registered.isAssignableFrom(target)) {
            exceptionTargetsMap.put(exceptionType, target);
        } else if (!target.isAssignableFrom(registered)) {
            String msg = String.format("Only one target for an exception should be defined. Found '%s' and '%s' for exception '%s'", target.getName(), registered.getName(), exceptionType.getName());
            throw new InvalidRouteLayoutConfigurationException(msg);
        }
    }

    private void initErrorTargets(Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap) {
        if (!exceptionTargetsMap.containsKey(NotFoundException.class)) {
            exceptionTargetsMap.put(NotFoundException.class, RouteNotFoundError.class);
        }
        if (!exceptionTargetsMap.containsKey(Exception.class)) {
            exceptionTargetsMap.put(Exception.class, InternalServerError.class);
        }
        if (!this.exceptionTargets.compareAndSet(null, exceptionTargetsMap)) {
            throw new IllegalStateException("Exception targets has been already initialized");
        }
    }

    public Optional<ErrorTargetEntry> getErrorNavigationTarget(Exception exception) {
        ErrorTargetEntry result;
        if (!this.errorNavigationTargetsInitialized()) {
            this.initErrorTargets(new HashMap<Class<? extends Exception>, Class<? extends Component>>());
        }
        if ((result = this.searchByCause(exception)) == null) {
            result = this.searchBySuperType(exception);
        }
        return Optional.ofNullable(result);
    }

    private ErrorTargetEntry searchByCause(Exception exception) {
        Class<? extends Component> targetClass = this.exceptionTargets.get().get(exception.getClass());
        if (targetClass != null) {
            return new ErrorTargetEntry(targetClass, exception.getClass());
        }
        Throwable cause = exception.getCause();
        if (cause instanceof Exception) {
            return this.searchByCause((Exception)cause);
        }
        return null;
    }

    private ErrorTargetEntry searchBySuperType(Throwable exception) {
        for (Class<?> superClass = exception.getClass().getSuperclass(); superClass != null && Exception.class.isAssignableFrom(superClass); superClass = superClass.getSuperclass()) {
            Class<? extends Component> targetClass = this.exceptionTargets.get().get(superClass);
            if (targetClass == null) continue;
            return new ErrorTargetEntry(targetClass, superClass.asSubclass(Exception.class));
        }
        return null;
    }

    public Optional<Class<? extends Component>> getNavigationTarget(String pathString) {
        Objects.requireNonNull(pathString, "pathString must not be null.");
        return this.getNavigationTarget(pathString, new ArrayList<String>());
    }

    public Optional<Class<? extends Component>> getNavigationTarget(String pathString, List<String> segments) {
        if (this.hasRouteTo(pathString)) {
            return Optional.ofNullable(this.getRoutes().get(pathString).getTarget(segments));
        }
        return Optional.empty();
    }

    public boolean hasRouteTo(String pathString) {
        Objects.requireNonNull(pathString, "pathString must not be null.");
        return this.getRoutes().containsKey(pathString);
    }

    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget) {
        Objects.requireNonNull(navigationTarget, "Target must not be null.");
        return Optional.ofNullable(this.collectRequiredParameters(navigationTarget));
    }

    private String collectRequiredParameters(Class<? extends Component> navigationTarget) {
        StringBuilder route = new StringBuilder(this.targetRoutes.get().get(navigationTarget));
        List<Class<?>> routeParameters = this.getRouteParameters(navigationTarget);
        if (!routeParameters.isEmpty()) {
            routeParameters.forEach(param -> route.append("/{").append(param.getSimpleName()).append("}"));
        }
        return route.toString();
    }

    public boolean navigationTargetsInitialized() {
        return this.routes.get() != null;
    }

    private String getNavigationRoute(Class<?> navigationTarget, Collection<String> aliases) {
        Route annotation = navigationTarget.getAnnotation(Route.class);
        aliases.addAll(this.getRouteAliases(navigationTarget));
        return RouterUtil.getRoutePath(navigationTarget, annotation);
    }

    private Collection<String> getRouteAliases(Class<?> navigationTarget) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (RouteAlias alias : (RouteAlias[])navigationTarget.getAnnotationsByType(RouteAlias.class)) {
            aliases.add(RouterUtil.getRouteAliasPath(navigationTarget, alias));
        }
        return aliases;
    }

    private void registerNavigationTargets(Set<Class<? extends Component>> navigationTargets) throws InvalidRouteConfigurationException {
        HashMap<String, RouteTarget> routesMap = new HashMap<String, RouteTarget>();
        HashMap<Class<? extends Component>, String> targetRoutesMap = new HashMap<Class<? extends Component>, String>();
        for (Class<? extends Component> navigationTarget : navigationTargets) {
            if (!navigationTarget.isAnnotationPresent(Route.class)) {
                throw new InvalidRouteConfigurationException(String.format("No Route annotation is present for the given navigation target component '%s'.", navigationTarget.getName()));
            }
            if (!this.routeFilters.stream().allMatch(filter -> filter.testNavigationTarget(navigationTarget))) continue;
            HashSet<String> paths = new HashSet<String>();
            String route = this.getNavigationRoute(navigationTarget, paths);
            paths.add(route);
            targetRoutesMap.put(navigationTarget, route);
            this.addRoute(routesMap, navigationTarget, paths);
        }
        if (!this.routes.compareAndSet(null, Collections.unmodifiableMap(routesMap))) {
            throw new IllegalStateException("Route registry has been already initialized");
        }
        if (!this.targetRoutes.compareAndSet(null, Collections.unmodifiableMap(targetRoutesMap))) {
            throw new IllegalStateException("Route registry has been already initialized");
        }
    }

    private void addRoute(Map<String, RouteTarget> routesMap, Class<? extends Component> navigationTarget, Collection<String> paths) throws InvalidRouteConfigurationException {
        Logger logger = LoggerFactory.getLogger((String)RouteRegistry.class.getName());
        for (String path : paths) {
            RouteTarget routeTarget;
            if (routesMap.containsKey(path)) {
                routeTarget = routesMap.get(path);
                routeTarget.addRoute(navigationTarget);
            } else {
                logger.debug("Registering route '{}' to navigation target '{}'.", (Object)path, (Object)navigationTarget.getName());
                routeTarget = new RouteTarget(navigationTarget);
                routesMap.put(path, routeTarget);
            }
            routeTarget.setThemeFor(navigationTarget, this.findThemeForNavigationTarget(navigationTarget, path));
        }
    }

    private ThemeDefinition findThemeForNavigationTarget(Class<?> navigationTarget, String path) {
        if (navigationTarget == null) {
            return LUMO_CLASS_IF_AVAILABLE;
        }
        Class<? extends RouterLayout> topParentLayout = RouterUtil.getTopParentLayout(navigationTarget, path);
        Class<Object> target = topParentLayout == null ? navigationTarget : topParentLayout;
        Optional<Theme> themeAnnotation = AnnotationReader.getAnnotationFor(target, Theme.class);
        if (themeAnnotation.isPresent()) {
            return new ThemeDefinition(themeAnnotation.get());
        }
        if (!AnnotationReader.getAnnotationFor(target, NoTheme.class).isPresent()) {
            return LUMO_CLASS_IF_AVAILABLE;
        }
        return null;
    }

    public boolean hasNavigationTargets() {
        return !this.getRoutes().isEmpty();
    }

    private Map<String, RouteTarget> getRoutes() {
        Map<String, RouteTarget> map = this.routes.get();
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public boolean hasRoutes() {
        return this.navigationTargetsInitialized() && !this.routes.get().isEmpty();
    }

    public Optional<ThemeDefinition> getThemeFor(Class<?> navigationTarget, String path) {
        if (navigationTarget != null && this.navigationTargetsInitialized()) {
            ThemeDefinition theme;
            RouteTarget routeTarget = null;
            if (path != null) {
                routeTarget = this.routes.get().get(path);
            }
            Map<Class<? extends Component>, String> targetRoutesMap = this.targetRoutes.get();
            if (routeTarget == null && targetRoutesMap.containsKey(navigationTarget)) {
                String routePath = targetRoutesMap.get(navigationTarget);
                routeTarget = this.routes.get().get(routePath);
            }
            if (routeTarget != null && (theme = routeTarget.getThemeFor(navigationTarget)) != null) {
                return Optional.of(theme);
            }
        }
        return Optional.ofNullable(this.findThemeForNavigationTarget(navigationTarget, path));
    }

    public static class ErrorTargetEntry
    implements Serializable {
        private final Class<? extends Component> navigationTarget;
        private final Class<? extends Exception> handledExceptionType;

        public ErrorTargetEntry(Class<? extends Component> navigationTarget, Class<? extends Exception> handledExceptionType) {
            assert (navigationTarget != null);
            assert (handledExceptionType != null);
            this.navigationTarget = navigationTarget;
            this.handledExceptionType = handledExceptionType;
        }

        public Class<? extends Component> getNavigationTarget() {
            return this.navigationTarget;
        }

        public Class<? extends Exception> getHandledExceptionType() {
            return this.handledExceptionType;
        }
    }
}

