/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.ui.LoadMode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMetaData {
    private static final String HTML_IMPORT_WITHOUT_JS_MODULE_WARNING = System.lineSeparator() + "{} has only @HtmlImport annotation(s) which is ignored in Vaadin 14+. This annotation is only useful in compatibility mode. In order to use a Polymer template inside a component in Vaadin 14+, @JsModule annotation should be used. And to use a css file, {@link CssImport} should be used. If you want to be able to use your component in both compatibility mode and normal mode of Vaadin 14+ you need to have @HtmlImport along with @JsModule and/or @CssImport annotations.Go to Vaadin 14 Migration Guide (https://vaadin.com/docs/v14/flow/v14-migration/v14-migration-guide.html#3-convert-polymer-2-to-polymer-3) to see how to migrate templates from Polymer 2 to Polymer 3.";
    private final Collection<SynchronizedPropertyInfo> synchronizedProperties;
    private final ConcurrentHashMap<VaadinService, DependencyInfo> dependencyInfo = new ConcurrentHashMap();
    private final Class<? extends Component> componentClass;

    public ComponentMetaData(Class<? extends Component> componentClass) {
        this.componentClass = componentClass;
        this.synchronizedProperties = ComponentMetaData.findSynchronizedProperties(componentClass);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ComponentMetaData.class.getName());
    }

    private static DependencyInfo findDependencies(VaadinService service, Class<? extends Component> componentClass) {
        DependencyInfo dependencyInfo = new DependencyInfo();
        ComponentMetaData.findDependencies(service, componentClass, dependencyInfo, new HashSet<Class<? extends Component>>());
        return dependencyInfo;
    }

    private static DependencyInfo findDependencies(VaadinService service, Class<? extends Component> componentClass, DependencyInfo dependencyInfo, Set<Class<? extends Component>> scannedClasses) {
        assert (!scannedClasses.contains(componentClass));
        scannedClasses.add(componentClass);
        List<JsModule> jsModules = AnnotationReader.getJsModuleAnnotations(componentClass);
        if (!jsModules.isEmpty()) {
            dependencyInfo.jsModules.addAll(jsModules);
        }
        dependencyInfo.javaScripts.addAll(AnnotationReader.getJavaScriptAnnotations(componentClass));
        dependencyInfo.styleSheets.addAll(AnnotationReader.getStyleSheetAnnotations(componentClass));
        dependencyInfo.cssImports.addAll(AnnotationReader.getCssImportAnnotations(componentClass));
        List<Uses> usesList = AnnotationReader.getAnnotationsFor(componentClass, Uses.class);
        for (Uses uses : usesList) {
            Class<? extends Component> otherClass = uses.value();
            if (scannedClasses.contains(otherClass)) continue;
            ComponentMetaData.findDependencies(service, otherClass, dependencyInfo, scannedClasses);
        }
        return dependencyInfo;
    }

    public Collection<SynchronizedPropertyInfo> getSynchronizedProperties() {
        return Collections.unmodifiableCollection(this.synchronizedProperties);
    }

    public DependencyInfo getDependencyInfo(VaadinService service) {
        return this.dependencyInfo.computeIfAbsent(service, ignore -> {
            service.addServiceDestroyListener(event -> this.dependencyInfo.remove(service));
            return ComponentMetaData.findDependencies(service, this.componentClass);
        });
    }

    private static Collection<SynchronizedPropertyInfo> findSynchronizedProperties(Class<? extends Component> componentClass) {
        HashMap<String, SynchronizedPropertyInfo> infos = new HashMap<String, SynchronizedPropertyInfo>();
        ComponentMetaData.collectSynchronizedProperties(componentClass, infos);
        return infos.values();
    }

    private static void collectSynchronizedProperties(Class<?> clazz, Map<String, SynchronizedPropertyInfo> infos) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        ComponentMetaData.doCollectSynchronizedProperties(clazz, infos);
        Class<?> superclass = clazz.getSuperclass();
        ComponentMetaData.collectSynchronizedProperties(superclass, infos);
        Stream.of(clazz.getInterfaces()).forEach(iface -> ComponentMetaData.collectSynchronizedProperties(iface, infos));
    }

    private static void doCollectSynchronizedProperties(Class<?> clazz, Map<String, SynchronizedPropertyInfo> infos) {
        for (Method method : clazz.getDeclaredMethods()) {
            Synchronize annotation = method.getAnnotation(Synchronize.class);
            if (annotation == null) continue;
            if (!ReflectTools.isGetter(method)) {
                throw new IllegalStateException(method + " is annotated with @" + Synchronize.class.getSimpleName() + " even though it's not a getter.");
            }
            if (infos.containsKey(method.getName())) continue;
            String propertyName = annotation.property().isEmpty() ? ReflectTools.getPropertyName(method) : annotation.property();
            String[] eventNames = annotation.value();
            infos.put(method.getName(), new SynchronizedPropertyInfo(propertyName, eventNames, annotation.allowUpdates()));
        }
    }

    public static class SynchronizedPropertyInfo {
        private final String property;
        private final DisabledUpdateMode mode;
        private final String[] eventNames;

        SynchronizedPropertyInfo(String property, String[] eventNames, DisabledUpdateMode mode) {
            this.property = property;
            this.eventNames = eventNames;
            this.mode = mode;
        }

        public String getProperty() {
            return this.property;
        }

        public Stream<String> getEventNames() {
            return Stream.of(this.eventNames);
        }

        public DisabledUpdateMode getUpdateMode() {
            return this.mode;
        }
    }

    public static class HtmlImportDependency {
        private final Collection<String> uris;
        private final LoadMode loadMode;

        private HtmlImportDependency(Collection<String> uris, LoadMode loadMode) {
            this.uris = Collections.unmodifiableCollection(uris);
            this.loadMode = loadMode;
        }

        public Collection<String> getUris() {
            return this.uris;
        }

        public LoadMode getLoadMode() {
            return this.loadMode;
        }
    }

    public static class DependencyInfo {
        private final List<JavaScript> javaScripts = new ArrayList<JavaScript>();
        private final List<JsModule> jsModules = new ArrayList<JsModule>();
        private final List<StyleSheet> styleSheets = new ArrayList<StyleSheet>();
        private final List<CssImport> cssImports = new ArrayList<CssImport>();

        List<JavaScript> getJavaScripts() {
            return Collections.unmodifiableList(this.javaScripts);
        }

        List<JsModule> getJsModules() {
            return Collections.unmodifiableList(this.jsModules);
        }

        List<StyleSheet> getStyleSheets() {
            return Collections.unmodifiableList(this.styleSheets);
        }

        List<CssImport> getCssImports() {
            return Collections.unmodifiableList(this.cssImports);
        }
    }
}

