/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.ReconnectDialogConfiguration;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import java.io.Serializable;

public class ReconnectDialogConfigurationMap
extends NodeMap
implements ReconnectDialogConfiguration {
    public static final String DIALOG_TEXT_KEY = "dialogText";
    public static final String DIALOG_TEXT_DEFAULT = "Server connection lost, trying to reconnect...";
    public static final String DIALOG_TEXT_GAVE_UP_KEY = "dialogTextGaveUp";
    public static final String DIALOG_TEXT_GAVE_UP_DEFAULT = "Server connection lost.";
    public static final String RECONNECT_ATTEMPTS_KEY = "reconnectAttempts";
    public static final int RECONNECT_ATTEMPTS_DEFAULT = 10000;
    public static final String RECONNECT_INTERVAL_KEY = "reconnectInterval";
    public static final int RECONNECT_INTERVAL_DEFAULT = 5000;
    public static final String DIALOG_GRACE_PERIOD_KEY = "dialogGracePeriod";
    public static final int DIALOG_GRACE_PERIOD_DEFAULT = 400;
    public static final String DIALOG_MODAL_KEY = "dialogModal";
    public static final boolean DIALOG_MODAL_DEFAULT = false;

    public ReconnectDialogConfigurationMap(StateNode node) {
        super(node);
    }

    @Override
    public String getDialogText() {
        return this.getOrDefault(DIALOG_TEXT_KEY, DIALOG_TEXT_DEFAULT);
    }

    @Override
    public void setDialogText(String dialogText) {
        this.put(DIALOG_TEXT_KEY, (Serializable)((Object)dialogText));
    }

    @Override
    public String getDialogTextGaveUp() {
        return this.getOrDefault(DIALOG_TEXT_GAVE_UP_KEY, DIALOG_TEXT_GAVE_UP_DEFAULT);
    }

    @Override
    public void setDialogTextGaveUp(String dialogTextGaveUp) {
        this.put(DIALOG_TEXT_GAVE_UP_KEY, (Serializable)((Object)dialogTextGaveUp));
    }

    @Override
    public int getReconnectAttempts() {
        return this.getOrDefault(RECONNECT_ATTEMPTS_KEY, 10000);
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.put(RECONNECT_ATTEMPTS_KEY, Integer.valueOf(reconnectAttempts));
    }

    @Override
    public int getReconnectInterval() {
        return this.getOrDefault(RECONNECT_INTERVAL_KEY, 5000);
    }

    @Override
    public void setReconnectInterval(int reconnectInterval) {
        this.put(RECONNECT_INTERVAL_KEY, Integer.valueOf(reconnectInterval));
    }

    @Override
    public int getDialogGracePeriod() {
        return this.getOrDefault(DIALOG_GRACE_PERIOD_KEY, 400);
    }

    @Override
    public void setDialogGracePeriod(int dialogGracePeriod) {
        this.put(DIALOG_GRACE_PERIOD_KEY, Integer.valueOf(dialogGracePeriod));
    }

    @Override
    public boolean isDialogModal() {
        return this.getOrDefault(DIALOG_MODAL_KEY, false);
    }

    @Override
    public void setDialogModal(boolean dialogModal) {
        this.put(DIALOG_MODAL_KEY, Boolean.valueOf(dialogModal));
    }
}

