/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceWriter;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.ServletContext;

public class StreamResourceHandler
implements Serializable {
    public void handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamResource streamResource) throws IOException {
        StreamResourceWriter writer;
        session.lock();
        try {
            ServletContext context = ((VaadinServletRequest)request).getServletContext();
            response.setContentType((String)streamResource.getContentTypeResolver().apply(streamResource, context));
            response.setCacheTime(streamResource.getCacheTime());
            streamResource.getHeaders().forEach((name, value) -> response.setHeader((String)name, (String)value));
            writer = streamResource.getWriter();
            if (writer == null) {
                throw new IOException("Stream resource produces null input stream");
            }
        }
        catch (Exception exception) {
            response.setStatus(500);
            throw exception;
        }
        finally {
            session.unlock();
        }
        try (OutputStream outputStream = null;){
            outputStream = response.getOutputStream();
            writer.accept(outputStream, session);
        }
    }
}

