/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.WebpackConnectionException;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendUtils {
    public static final String PROJECT_BASEDIR = "project.basedir";
    public static final String DEFAULT_NODE_DIR = "./";
    public static final String NODE_MODULES = "node_modules/";
    public static final String FRONTEND = "frontend/";
    public static final String DEFAULT_FRONTEND_DIR = "./frontend/";
    public static final String WEBPACK_CONFIG = "webpack.config.js";
    public static final String WEBPACK_GENERATED = "webpack.generated.js";
    public static final String TARGET = "target/";
    public static final String FLOW_NPM_PACKAGE_NAME = "@vaadin/flow-frontend/";
    public static final String DEAULT_FLOW_RESOURCES_FOLDER = "target/flow-frontend";
    public static final String DEVMODE_GIZMO_MODULE = "@vaadin/flow-frontend/VaadinDevmodeGizmo.js";
    public static final String DEFAULT_GENERATED_DIR = "target/frontend/";
    public static final String IMPORTS_NAME = "generated-flow-imports.js";
    public static final String FALLBACK_IMPORTS_NAME = "generated-flow-imports-fallback.js";
    public static final String PARAM_GENERATED_DIR = "vaadin.frontend.generated.folder";
    public static final String PARAM_FRONTEND_DIR = "vaadin.frontend.frontend.folder";
    public static final String PARAM_IGNORE_VERSION_CHECKS = "vaadin.ignoreVersionChecks";
    public static final String WEBPACK_PREFIX_ALIAS = "Frontend/";
    public static final String TOKEN_FILE = "config/flow-build-info.json";
    public static final String CHUNKS = "chunks";
    public static final String FALLBACK = "fallback";
    public static final String CSS_IMPORTS = "cssImports";
    public static final String JS_MODULES = "jsModules";
    public static final String PARAM_TOKEN_FILE = "vaadin.frontend.token.file";
    public static final String DISABLE_CHECK = "%nYou can disable the version check using -D%s=true";
    private static final String NO_CONNECTION = "Webpack-dev-server couldn't be reached for %s.%nCheck the startup logs for exceptions in running webpack-dev-server.%nIf server should be running in production mode check that production mode flag is set correctly.";
    private static final String SHOULD_WORK = "%n%n======================================================================================================%nYour installed '%s' version (%s) is not supported but should still work. Supported versions are %d.%d+%nYou can install a new one:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v14.21.3\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final String TOO_OLD = "%n%n======================================================================================================%nYour installed '%s' version (%s) is too old. Supported versions are %d.%d+%nPlease install a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.10.0:install-node-and-npm -DnodeVersion=\"v14.21.3\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    static final String SYSTEM_NOPROXY_PROPERTY_KEY = "NOPROXY";
    static final String SYSTEM_HTTPS_PROXY_PROPERTY_KEY = "HTTPS_PROXY";
    static final String SYSTEM_HTTP_PROXY_PROPERTY_KEY = "HTTP_PROXY";
    private static String operatingSystem = null;
    public static final String YELLOW = "\u001b[38;5;111m%s\u001b[0m";
    public static final String RED = "\u001b[38;5;196m%s\u001b[0m";
    public static final String GREEN = "\u001b[38;5;35m%s\u001b[0m";
    public static final String BRIGHT_BLUE = "\u001b[94m%s\u001b[0m";

    private FrontendUtils() {
    }

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name");
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return FrontendUtils.getOsName().startsWith("Windows");
    }

    private static String getNonNull(String ... valueArray) {
        for (String value : valueArray) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String streamToString(InputStream inputStream) {
        String ret = "";
        try (InputStream handledStream = inputStream;){
            String string = IOUtils.toString((InputStream)handledStream, (Charset)StandardCharsets.UTF_8).replaceAll("\\R", System.lineSeparator());
            return string;
        }
        catch (IOException exception) {
            LoggerFactory.getLogger(FrontendUtils.class).warn("Couldn't close template input stream", (Throwable)exception);
            return ret;
        }
    }

    public static ProcessBuilder createProcessBuilder(List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandFile = new File(command.get(0));
        if (commandFile.isAbsolute()) {
            String pathEnvVar;
            String commandPath = commandFile.getParent();
            Map<String, String> environment = processBuilder.environment();
            String path = environment.get(pathEnvVar = FrontendUtils.isWindows() ? environment.keySet().stream().filter("PATH"::equalsIgnoreCase).findFirst().orElse("Path") : "PATH");
            if (path == null || path.isEmpty()) {
                path = commandPath;
            } else if (!path.contains(commandPath)) {
                path = path + File.pathSeparatorChar + commandPath;
            }
            environment.put(pathEnvVar, path);
        }
        return processBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStatsContent(VaadinService service) throws IOException {
        String string;
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        InputStream content = null;
        try {
            if (!config.isProductionMode() && config.enableDevServer()) {
                content = FrontendUtils.getStatsFromWebpack();
            }
            if (config.isStatsExternal()) {
                content = FrontendUtils.getStatsFromExternalUrl(config.getExternalStatsUrl(), service.getContext());
            }
            if (content == null) {
                content = FrontendUtils.getStatsFromClassPath(service);
            }
            string = content != null ? IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8) : null;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(content);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)content);
        return string;
    }

    public static String getStatsHash(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (!config.isProductionMode() && config.enableDevServer()) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            HttpURLConnection statsConnection = handler.prepareConnection("/stats.hash", "GET");
            if (statsConnection.getResponseCode() != 200) {
                throw new WebpackConnectionException(String.format(NO_CONNECTION, "getting the stats content hash."));
            }
            return FrontendUtils.streamToString(statsConnection.getInputStream()).replaceAll("\"", "");
        }
        return "";
    }

    public static void clearCachedStatsContent(VaadinService service) {
        service.getContext().removeAttribute(Stats.class);
    }

    private static InputStream getStatsFromWebpack() throws IOException {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        HttpURLConnection statsConnection = handler.prepareConnection("/stats.json", "GET");
        if (statsConnection.getResponseCode() != 200) {
            throw new WebpackConnectionException(String.format(NO_CONNECTION, "downloading stats.json"));
        }
        return statsConnection.getInputStream();
    }

    private static InputStream getStatsFromExternalUrl(String externalStatsUrl, VaadinContext context) {
        String url;
        if (externalStatsUrl.startsWith("/")) {
            VaadinRequest request = VaadinRequest.getCurrent();
            url = FrontendUtils.getHostString(request) + externalStatsUrl;
        } else {
            url = externalStatsUrl;
        }
        try {
            URL uri = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(60000);
            connection.setConnectTimeout(60000);
            String lastModified = connection.getHeaderField("last-modified");
            if (lastModified != null) {
                LocalDateTime modified = ZonedDateTime.parse(lastModified, DateTimeFormatter.RFC_1123_DATE_TIME).toLocalDateTime();
                Stats statistics = context.getAttribute(Stats.class);
                if (statistics == null || modified.isAfter(statistics.getLastModified().orElse(LocalDateTime.MIN))) {
                    byte[] buffer = IOUtils.toByteArray((InputStream)connection.getInputStream());
                    statistics = new Stats(buffer, lastModified);
                    context.setAttribute(statistics);
                }
                return new ByteArrayInputStream(statistics.statsJson);
            }
            return connection.getInputStream();
        }
        catch (IOException e) {
            FrontendUtils.getLogger().error("Failed to retrieve stats.json from the url {}.", (Object)url, (Object)e);
            return null;
        }
    }

    private static String getHostString(VaadinRequest request) {
        String host = request.getHeader("host");
        if (host == null) {
            host = "http://127.0.0.1:8080";
        } else if (!host.contains("://")) {
            String scheme = request.getHeader("scheme");
            if (scheme == null) {
                scheme = "http";
            }
            host = scheme + "://" + host;
        }
        return host;
    }

    private static InputStream getStatsFromClassPath(VaadinService service) throws IOException {
        Stats statistics = service.getContext().getAttribute(Stats.class);
        if (statistics != null) {
            return new ByteArrayInputStream(statistics.statsJson);
        }
        String stats = service.getDeploymentConfiguration().getStringProperty("statistics.file.path", "META-INF/VAADIN/config/stats.json").replaceFirst("^/", "");
        ResourceProvider resourceProvider = service.getContext().getAttribute(Lookup.class).lookup(ResourceProvider.class);
        URL statsUrl = resourceProvider.getApplicationResource(service.getContext(), stats);
        ByteArrayInputStream stream = null;
        if (statsUrl != null) {
            try (InputStream statsStream = statsUrl.openStream();){
                byte[] buffer = IOUtils.toByteArray((InputStream)statsStream);
                statistics = new Stats(buffer, null);
                service.getContext().setAttribute(statistics);
                stream = new ByteArrayInputStream(buffer);
            }
            catch (IOException exception) {
                FrontendUtils.getLogger().warn("Couldn't read content of stats file {}", (Object)stats, (Object)exception);
                stream = null;
            }
        }
        if (stream == null) {
            FrontendUtils.getLogger().error("Cannot get the 'stats.json' from the classpath '{}'", (Object)stats);
        }
        return stream;
    }

    public static String getStatsAssetsByChunkName(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        if (!config.isProductionMode() && config.enableDevServer()) {
            DevModeHandler handler = DevModeHandler.getDevModeHandler();
            HttpURLConnection assetsConnection = handler.prepareConnection("/assetsByChunkName", "GET");
            if (assetsConnection.getResponseCode() != 200) {
                throw new WebpackConnectionException(String.format(NO_CONNECTION, "getting assets by chunk name."));
            }
            return FrontendUtils.streamToString(assetsConnection.getInputStream());
        }
        InputStream resourceAsStream = config.isStatsExternal() ? FrontendUtils.getStatsFromExternalUrl(config.getExternalStatsUrl(), service.getContext()) : FrontendUtils.getStatsFromClassPath(service);
        if (resourceAsStream == null) {
            return null;
        }
        try (Scanner scan = new Scanner(resourceAsStream, StandardCharsets.UTF_8.name());){
            StringBuilder assets = new StringBuilder();
            assets.append("{");
            FrontendUtils.scanToAssetChunkStart(scan, assets);
            while (scan.hasNextLine()) {
                String line = scan.nextLine().trim();
                if ("}".equals(line) || "},".equals(line)) {
                    String string = assets.append("}").toString();
                    return string;
                }
                if (line.endsWith("}") || line.endsWith("},")) {
                    String string = assets.append(line.substring(0, line.indexOf(125)).trim()).append("}").toString();
                    return string;
                }
                if (line.contains("{")) break;
                assets.append(line);
            }
            FrontendUtils.getLogger().error("Could not parse assetsByChunkName from stats.json");
        }
        return null;
    }

    private static void scanToAssetChunkStart(Scanner scan, StringBuilder assets) {
        do {
            String line;
            if (!(line = scan.nextLine().trim()).startsWith("\"assetsByChunkName\"")) continue;
            if (line.endsWith("{")) break;
            assets.append(line.substring(line.indexOf(123) + 1).trim());
            break;
        } while (scan.hasNextLine());
    }

    private static String buildTooOldString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(TOO_OLD, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    private static String buildShouldWorkString(String tool, String version, int supportedMajor, int supportedMinor) {
        return String.format(SHOULD_WORK, tool, version, supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS);
    }

    public static boolean isWebpackConfigFile(File file) throws IOException {
        return file.exists() && FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).contains("./webpack.generated.js");
    }

    public static String getUnixRelativePath(Path source, Path target) {
        return FrontendUtils.getUnixPath(source.relativize(target));
    }

    public static String getUnixPath(Path source) {
        return source.toString().replaceAll("\\\\", "/");
    }

    public static FallbackChunk readFallbackChunk(JsonObject object) {
        if (!object.hasKey(CHUNKS)) {
            return null;
        }
        JsonObject obj = object.getObject(CHUNKS);
        if (!obj.hasKey(FALLBACK)) {
            return null;
        }
        obj = obj.getObject(FALLBACK);
        ArrayList<String> fallbackModles = new ArrayList<String>();
        JsonArray modules = obj.getArray(JS_MODULES);
        for (int i = 0; i < modules.length(); ++i) {
            fallbackModles.add(modules.getString(i));
        }
        ArrayList<FallbackChunk.CssImportData> fallbackCss = new ArrayList<FallbackChunk.CssImportData>();
        JsonArray css = obj.getArray(CSS_IMPORTS);
        for (int i = 0; i < css.length(); ++i) {
            fallbackCss.add(FrontendUtils.createCssData(css.getObject(i)));
        }
        return new FallbackChunk(fallbackModles, fallbackCss);
    }

    private static FallbackChunk.CssImportData createCssData(JsonObject object) {
        String value = null;
        String id = null;
        String include = null;
        String themeFor = null;
        if (object.hasKey("value")) {
            value = object.getString("value");
        }
        if (object.hasKey("id")) {
            id = object.getString("id");
        }
        if (object.hasKey("include")) {
            include = object.getString("include");
        }
        if (object.hasKey("themeFor")) {
            themeFor = object.getString("themeFor");
        }
        return new FallbackChunk.CssImportData(value, id, include, themeFor);
    }

    static void validateToolVersion(String tool, FrontendVersion toolVersion, FrontendVersion supported, FrontendVersion shouldWork) {
        if (FrontendUtils.isVersionAtLeast(toolVersion, supported)) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(toolVersion, shouldWork)) {
            FrontendUtils.getLogger().warn(FrontendUtils.buildShouldWorkString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
            return;
        }
        throw new IllegalStateException(FrontendUtils.buildTooOldString(tool, toolVersion.getFullVersion(), supported.getMajorVersion(), supported.getMinorVersion()));
    }

    static boolean isVersionAtLeast(FrontendVersion toolVersion, FrontendVersion required) {
        int major = toolVersion.getMajorVersion();
        int minor = toolVersion.getMinorVersion();
        return major > required.getMajorVersion() || major == required.getMajorVersion() && minor >= required.getMinorVersion();
    }

    protected static FrontendVersion getVersion(String tool, List<String> versionCommand) throws UnknownVersionException {
        try {
            String output = FrontendUtils.executeCommand(versionCommand);
            return new FrontendVersion(FrontendUtils.parseVersionString(output));
        }
        catch (CommandExecutionException | IOException e) {
            throw new UnknownVersionException(tool, "Using command " + String.join((CharSequence)" ", versionCommand), e);
        }
    }

    public static String executeCommand(List<String> command) throws CommandExecutionException {
        try {
            Process process = FrontendUtils.createProcessBuilder(command).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new CommandExecutionException(exitCode, FrontendUtils.streamToString(process.getInputStream()), FrontendUtils.streamToString(process.getErrorStream()));
            }
            return FrontendUtils.streamToString(process.getInputStream());
        }
        catch (IOException | InterruptedException e) {
            throw new CommandExecutionException(e);
        }
    }

    public static FrontendVersion parseFrontendVersion(String versionString) throws IOException {
        return new FrontendVersion(FrontendUtils.parseVersionString(versionString));
    }

    public static File getVaadinHomeDirectory() {
        File home = FileUtils.getUserDirectory();
        if (!home.exists()) {
            throw new IllegalStateException("The user directory '" + home.getAbsolutePath() + "' doesn't exist");
        }
        if (!home.isDirectory()) {
            throw new IllegalStateException("The path '" + home.getAbsolutePath() + "' is not a directory");
        }
        File vaadinFolder = new File(home, ".vaadin");
        if (vaadinFolder.exists()) {
            if (vaadinFolder.isDirectory()) {
                return vaadinFolder;
            }
            throw new IllegalStateException("The path '" + vaadinFolder.getAbsolutePath() + "' is not a directory. This path is used to store vaadin related data. Please either remove the file or create a directory");
        }
        try {
            FileUtils.forceMkdir((File)vaadinFolder);
            return vaadinFolder;
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Couldn't create '.vaadin' folder inside home directory '" + home.getAbsolutePath() + "'", exception);
        }
    }

    static String parseVersionString(String output) throws IOException {
        Optional<String> lastOuput = Stream.of(output.split("\n")).filter(line -> !line.matches("^[ ]*$")).reduce((first, second) -> second);
        return lastOuput.map(line -> line.replaceFirst("^v", "")).orElseThrow(() -> new IOException("No output"));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FrontendUtils.class);
    }

    public static String commandToString(String baseDir, List<String> command) {
        StringBuilder retval = new StringBuilder("\n");
        StringBuilder curLine = new StringBuilder();
        for (String fragment : command) {
            if (curLine.length() + fragment.length() > 55) {
                retval.append(curLine.toString());
                retval.append("\\ \n");
                curLine = new StringBuilder("    ");
            }
            curLine.append(fragment.replace(baseDir, "."));
            curLine.append(" ");
        }
        retval.append(curLine.toString());
        retval.append("\n");
        return retval.toString();
    }

    public static FrontendVersion getPackageVersionFromJson(JsonObject sourceJson, String pkg, String versionOrigin) {
        if (!sourceJson.hasKey(pkg)) {
            return null;
        }
        try {
            String versionString = sourceJson.getString(pkg);
            return new FrontendVersion(pkg, versionString);
        }
        catch (ClassCastException classCastException) {
            LoggerFactory.getLogger(FrontendVersion.class).warn("Ignoring error while parsing frontend dependency version for package '{}' in '{}'", (Object)pkg, (Object)versionOrigin);
        }
        catch (NumberFormatException nfe) {
            LoggerFactory.getLogger(FrontendVersion.class).warn("Ignoring error while parsing frontend dependency version in {}: {}", (Object)versionOrigin, (Object)nfe.getMessage());
        }
        return null;
    }

    public static void console(String format, Object message) {
        System.out.print(String.format(format, message));
    }

    public static void deleteNodeModules(File nodeModules) throws IOException {
        if (!nodeModules.exists()) {
            return;
        }
        if (!nodeModules.isDirectory() || !nodeModules.getName().equals("node_modules")) {
            throw new IOException(nodeModules.getAbsolutePath() + " does not look like a node_modules directory");
        }
        FrontendUtils.deleteDirectory(nodeModules);
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        if (!Files.isSymbolicLink(directory.toPath()) && !FrontendUtils.isJunction(directory.toPath())) {
            FrontendUtils.cleanDirectory(directory);
        }
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    private static boolean isJunction(Path directory) throws IOException {
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        BasicFileAttributes attrs = Files.readAttributes(directory, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        return isWindows && attrs.isDirectory() && attrs.isOther();
    }

    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                FrontendUtils.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FrontendUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    private static class Stats
    implements Serializable {
        private final String lastModified;
        protected final byte[] statsJson;

        public Stats(byte[] statsJson, String lastModified) {
            this.statsJson = statsJson;
            this.lastModified = lastModified;
        }

        public Optional<LocalDateTime> getLastModified() {
            if (this.lastModified == null) {
                return Optional.empty();
            }
            return Optional.of(ZonedDateTime.parse(this.lastModified, DateTimeFormatter.RFC_1123_DATE_TIME).toLocalDateTime());
        }
    }

    public static class CommandExecutionException
    extends Exception {
        public CommandExecutionException(int processExitCode) {
            super("Process execution failed with exit code " + processExitCode);
        }

        public CommandExecutionException(int processExitCode, String output, String errorOutput) {
            super("Process execution failed with exit code " + processExitCode + "\nOutput: " + output + "\nError output: " + errorOutput);
        }

        public CommandExecutionException(Throwable cause) {
            super("Process execution failed", cause);
        }
    }

    public static class UnknownVersionException
    extends Exception {
        public UnknownVersionException(String tool, String extraInfo) {
            super("Unable to detect version of " + tool + ". " + extraInfo);
        }

        public UnknownVersionException(String tool, String extraInfo, Exception cause) {
            super("Unable to detect version of " + tool + ". " + extraInfo, cause);
        }
    }
}

