/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionExpiredHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.JSR356WebsocketInitializer;
import com.vaadin.flow.server.communication.PushAtmosphereHandler;
import com.vaadin.flow.server.communication.PushHandler;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.util.VoidAnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushRequestHandler
implements RequestHandler,
SessionExpiredHandler {
    private AtmosphereFramework atmosphere;
    private PushHandler pushHandler;

    public PushRequestHandler(VaadinServletService service) throws ServiceException {
        service.addServiceDestroyListener(event -> this.destroy());
        ServletConfig vaadinServletConfig = service.getServlet().getServletConfig();
        this.pushHandler = this.createPushHandler(service);
        this.atmosphere = this.getPreInitializedAtmosphere(vaadinServletConfig);
        if (this.atmosphere == null) {
            PushRequestHandler.getLogger().debug("Initializing Atmosphere for servlet {}", (Object)vaadinServletConfig.getServletName());
            try {
                this.atmosphere = PushRequestHandler.initAtmosphere(vaadinServletConfig);
            }
            catch (Exception e) {
                throw new ServiceException("Failed to initialize Atmosphere for " + service.getServlet().getServletName() + ". Push will not work.", e);
            }
        } else {
            PushRequestHandler.getLogger().debug("Using pre-initialized Atmosphere for servlet {}", (Object)vaadinServletConfig.getServletName());
        }
        String timeout = service.getDeploymentConfiguration().getStringProperty("pushLongPollingSuspendTimeout", "-1");
        this.atmosphere.addInitParameter("pushLongPollingSuspendTimeout", timeout);
        this.pushHandler.setLongPollingSuspendTimeout(Integer.parseInt(timeout));
        for (AtmosphereFramework.AtmosphereHandlerWrapper handlerWrapper : this.atmosphere.getAtmosphereHandlers().values()) {
            AtmosphereHandler handler = handlerWrapper.atmosphereHandler;
            if (!(handler instanceof PushAtmosphereHandler)) continue;
            ((PushAtmosphereHandler)handler).setPushHandler(this.pushHandler);
        }
    }

    protected PushHandler createPushHandler(VaadinServletService service) {
        return new PushHandler(service);
    }

    private static final Logger getLogger() {
        return LoggerFactory.getLogger((String)PushRequestHandler.class.getName());
    }

    private AtmosphereFramework getPreInitializedAtmosphere(ServletConfig vaadinServletConfig) {
        String attributeName = JSR356WebsocketInitializer.getAttributeName(vaadinServletConfig.getServletName());
        Object framework = vaadinServletConfig.getServletContext().getAttribute(attributeName);
        if (framework != null && framework instanceof AtmosphereFramework) {
            return (AtmosphereFramework)framework;
        }
        return null;
    }

    static AtmosphereFramework initAtmosphere(final ServletConfig vaadinServletConfig) {
        AtmosphereFramework atmosphere = new AtmosphereFramework(false, false){

            protected void analytics() {
            }

            public AtmosphereFramework addInitParameter(String name, String value) {
                if (vaadinServletConfig.getInitParameter(name) == null) {
                    super.addInitParameter(name, value);
                }
                return this;
            }
        };
        atmosphere.addAtmosphereHandler("/*", (AtmosphereHandler)new PushAtmosphereHandler());
        atmosphere.addInitParameter("org.atmosphere.cpr.broadcasterCacheClass", UUIDBroadcasterCache.class.getName());
        atmosphere.addInitParameter("org.atmosphere.cpr.AnnotationProcessor", VoidAnnotationProcessor.class.getName());
        atmosphere.addInitParameter("org.atmosphere.cpr.sessionSupport", "true");
        atmosphere.addInitParameter("org.atmosphere.client.TrackMessageSizeInterceptor.delimiter", String.valueOf('|'));
        atmosphere.addInitParameter("org.atmosphere.cpr.dropAccessControlAllowOriginHeader", "false");
        atmosphere.addInitParameter("org.atmosphere.cpr.AtmosphereInterceptor.disable", HeartbeatInterceptor.class.getName());
        String bufferSize = String.valueOf(16384);
        atmosphere.addInitParameter("org.atmosphere.websocket.bufferSize", bufferSize);
        atmosphere.addInitParameter("org.atmosphere.websocket.maxTextMessageSize", bufferSize);
        atmosphere.addInitParameter("org.atmosphere.websocket.maxBinaryMessageSize", bufferSize);
        atmosphere.addInitParameter("org.atmosphere.cpr.removeSessionTimeout", "false");
        atmosphere.addInitParameter("org.atmosphere.cpr.recoverFromDestroyedBroadcaster", "false");
        atmosphere.addInitParameter("org.atmosphere.cpr.showSupportMessage", "false");
        try {
            atmosphere.init(vaadinServletConfig);
            TrackMessageSizeInterceptor trackMessageSize = new TrackMessageSizeInterceptor();
            trackMessageSize.configure(atmosphere.getAtmosphereConfig());
            atmosphere.interceptor((AtmosphereInterceptor)trackMessageSize);
        }
        catch (ServletException e) {
            throw new RuntimeException("Atmosphere init failed", e);
        }
        return atmosphere;
    }

    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (!HandlerHelper.isRequestType(request, HandlerHelper.RequestType.PUSH)) {
            return false;
        }
        if (request instanceof VaadinServletRequest) {
            if (this.atmosphere == null) {
                response.sendError(500, "Atmosphere initialization failed. No push available.");
                return true;
            }
            try {
                this.atmosphere.doCometSupport(AtmosphereRequestImpl.wrap((HttpServletRequest)((VaadinServletRequest)request)), AtmosphereResponseImpl.wrap((HttpServletResponse)((VaadinServletResponse)response)));
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Only VaadinServletRequests are supported");
        }
        return true;
    }

    public void destroy() {
        this.atmosphere.destroy();
    }

    @Override
    public boolean handleSessionExpired(VaadinRequest request, VaadinResponse response) throws IOException {
        return this.handleRequest(null, request, response);
    }
}

