/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.combobox.GeneratedVaadinComboBox;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.data.binder.HasFilterableDataProvider;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

@HtmlImport(value="frontend://flow-component-renderer.html")
@JavaScript(value="frontend://comboBoxConnector.js")
public class ComboBox<T>
extends GeneratedVaadinComboBox<ComboBox<T>, T>
implements HasSize,
HasValidation,
HasFilterableDataProvider<T, String> {
    private final ArrayUpdater arrayUpdater = new ArrayUpdater(){

        public ArrayUpdater.Update startUpdate(int sizeChange) {
            return new UpdateQueue(sizeChange);
        }

        public void initialize() {
            ComboBox.this.initConnector();
        }
    };
    private ItemLabelGenerator<T> itemLabelGenerator = String::valueOf;
    private Renderer<T> renderer;
    private boolean renderScheduled;
    private String lastFilter;
    private DataCommunicator<T> dataCommunicator;
    private final CompositeDataGenerator<T> dataGenerator = new CompositeDataGenerator();
    private Registration dataGeneratorRegistration;
    private Element template;
    private int customValueListenersCount;
    private SerializableConsumer<String> filterSlot = (SerializableConsumer & Serializable)filter -> {};
    private UserProvidedFilter userProvidedFilter = UserProvidedFilter.UNDECIDED;

    public ComboBox(int pageSize) {
        super(null, null, String.class, ComboBox::presentationToModel, ComboBox::modelToPresentation);
        this.dataGenerator.addDataGenerator((DataGenerator & Serializable)(item, jsonObject) -> jsonObject.put("label", this.generateLabel(item)));
        this.setItemValuePath("key");
        this.setItemIdPath("key");
        this.setPageSize(pageSize);
    }

    public ComboBox() {
        this(50);
    }

    public ComboBox(String label) {
        this();
        this.setLabel(label);
    }

    public ComboBox(String label, Collection<T> items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    @SafeVarargs
    public ComboBox(String label, T ... items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    private static <T> T presentationToModel(ComboBox<T> comboBox, String presentation) {
        if (presentation == null || comboBox.dataCommunicator == null) {
            return comboBox.getEmptyValue();
        }
        return (T)super.getKeyMapper().get(presentation);
    }

    private static <T> String modelToPresentation(ComboBox<T> comboBox, T model) {
        if (model == null) {
            return null;
        }
        return super.getKeyMapper().key(model);
    }

    public void setValue(T value) {
        if (this.dataCommunicator == null) {
            if (value == null) {
                return;
            }
            throw new IllegalStateException("Cannot set a value for a ComboBox without items. Use setItems or setDataProvider to populate items into the ComboBox before setting a value.");
        }
        super.setValue(value);
        DataKeyMapper<T> keyMapper = this.getKeyMapper();
        if (value != null && keyMapper.has(value)) {
            value = keyMapper.get(keyMapper.key(value));
        }
        if (value == null) {
            this.getElement().setProperty("selectedItem", null);
            this.getElement().setProperty("value", "");
            this.getElement().setProperty("_inputElementValue", "");
            return;
        }
        JsonObject json = Json.createObject();
        json.put("key", keyMapper.key(value));
        this.dataGenerator.generateData(value, json);
        this.setSelectedItem(json);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJavaScript("$0.value=$1", new Serializable[]{this.getElement(), this.getElement().getProperty("value")}));
    }

    public void setRenderer(Renderer<T> renderer) {
        Objects.requireNonNull(renderer, "The renderer must not be null");
        this.renderer = renderer;
        if (this.template == null) {
            this.template = new Element("template");
            this.getElement().appendChild(new Element[]{this.template});
        }
        this.scheduleRender();
    }

    public void setItems(Collection<T> items) {
        this.setDataProvider(DataProvider.ofCollection(items));
    }

    public void setItems(ItemFilter<T> itemFilter, Collection<T> items) {
        ListDataProvider listDataProvider = DataProvider.ofCollection(items);
        this.setDataProvider(itemFilter, listDataProvider);
    }

    public void setItems(ItemFilter<T> itemFilter, T ... items) {
        this.setItems(itemFilter, (Collection<T>)Arrays.asList(items));
    }

    public void setDataProvider(DataProvider<T, String> dataProvider) {
        this.setDataProvider(dataProvider, SerializableFunction.identity());
    }

    public <C> void setDataProvider(DataProvider<T, C> dataProvider, SerializableFunction<String, C> filterConverter) {
        Objects.requireNonNull(dataProvider, "The data provider can not be null");
        Objects.requireNonNull(filterConverter, "filterConverter cannot be null");
        if (this.userProvidedFilter == UserProvidedFilter.UNDECIDED) {
            this.userProvidedFilter = UserProvidedFilter.YES;
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJavaScript("window.Vaadin.Flow.comboBoxConnector.initLazy($0);", new Serializable[]{this.getElement()}));
        if (this.dataCommunicator == null) {
            this.dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> this.getElement().callFunction("$connector.updateData", new Serializable[]{data}), this.getElement().getNode());
        }
        this.getElement().callFunction("$connector.reset", new Serializable[0]);
        this.scheduleRender();
        this.setValue(null);
        SerializableFunction & Serializable convertOrNull = (SerializableFunction & Serializable)filterText -> {
            if (filterText == null) {
                return null;
            }
            return filterConverter.apply(filterText);
        };
        SerializableConsumer providerFilterSlot = this.dataCommunicator.setDataProvider(dataProvider, convertOrNull.apply((Object)this.getFilterString()));
        this.filterSlot = (SerializableConsumer & Serializable)filter -> providerFilterSlot.accept(convertOrNull.apply(filter));
        boolean shouldForceServerSideFiltering = this.userProvidedFilter == UserProvidedFilter.YES;
        dataProvider.addDataProviderListener((DataProviderListener & Serializable)e -> {
            if (e instanceof DataChangeEvent.DataRefreshEvent) {
                this.dataCommunicator.refresh(((DataChangeEvent.DataRefreshEvent)e).getItem());
            } else {
                this.refreshAllData(shouldForceServerSideFiltering);
            }
        });
        this.refreshAllData(shouldForceServerSideFiltering);
        this.userProvidedFilter = UserProvidedFilter.UNDECIDED;
    }

    private void refreshAllData(boolean forceServerSideFiltering) {
        int size = this.getDataProvider().size(new Query());
        this.setClientSideFilter(!forceServerSideFiltering && (double)size <= this.getPageSizeDouble());
        this.reset();
    }

    public void setDataProvider(ListDataProvider<T> listDataProvider) {
        if (this.userProvidedFilter == UserProvidedFilter.UNDECIDED) {
            this.userProvidedFilter = UserProvidedFilter.NO;
        }
        ItemFilter<Object> & Serializable defaultItemFilter = (ItemFilter<Object> & Serializable)(item, filterText) -> this.generateLabel(item).toLowerCase(this.getLocale()).contains(filterText.toLowerCase(this.getLocale()));
        this.setDataProvider(defaultItemFilter, listDataProvider);
    }

    public void setDataProvider(FetchItemsCallback<T> fetchItems, SerializableFunction<String, Integer> sizeCallback) {
        this.userProvidedFilter = UserProvidedFilter.YES;
        this.setDataProvider((DataProvider<T, String>)new CallbackDataProvider((CallbackDataProvider.FetchCallback & Serializable)q -> fetchItems.fetchItems(q.getFilter().orElse(""), q.getOffset(), q.getLimit()), (CallbackDataProvider.CountCallback & Serializable)q -> (Integer)sizeCallback.apply((Object)q.getFilter().orElse(""))));
    }

    public void setDataProvider(ItemFilter<T> itemFilter, ListDataProvider<T> listDataProvider) {
        Objects.requireNonNull(listDataProvider, "List data provider cannot be null");
        this.setDataProvider((DataProvider)listDataProvider, (SerializableFunction)(SerializableFunction & Serializable)filterText -> (SerializablePredicate & Serializable)item -> itemFilter.test((Object)item, (String)filterText));
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataCommunicator.getDataProvider();
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.reset();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size should be greater than zero.");
        }
        super.setPageSize(pageSize);
        this.reset();
    }

    public int getPageSize() {
        return this.getElement().getProperty("pageSize", 50);
    }

    @Override
    public void setOpened(boolean opened) {
        super.setOpened(opened);
    }

    public boolean isOpened() {
        return this.isOpenedBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setAllowCustomValue(boolean allowCustomValue) {
        super.setAllowCustomValue(allowCustomValue);
    }

    public boolean isAllowCustomValue() {
        return this.isAllowCustomValueBoolean();
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    @Override
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    public boolean isPreventInvalidInput() {
        return this.isPreventInvalidInputBoolean();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setPattern(String pattern) {
        super.setPattern(pattern);
    }

    public String getPattern() {
        return this.getPatternString();
    }

    public T getEmptyValue() {
        return null;
    }

    @Override
    public Registration addCustomValueSetListener(ComponentEventListener<GeneratedVaadinComboBox.CustomValueSetEvent<ComboBox<T>>> listener) {
        this.setAllowCustomValue(true);
        ++this.customValueListenersCount;
        Registration registration = super.addCustomValueSetListener(listener);
        return new CustomValueRegistration(registration);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.getElement().callFunction("$connector.enableClientValidation", new Serializable[]{Boolean.valueOf(!requiredIndicatorVisible)});
    }

    CompositeDataGenerator<T> getDataGenerator() {
        return this.dataGenerator;
    }

    private String generateLabel(T item) {
        if (item == null) {
            return "";
        }
        String label = this.getItemLabelGenerator().apply(item);
        if (label == null) {
            throw new IllegalStateException(String.format("Got 'null' as a label value for the item '%s'. '%s' instance may not return 'null' values", item, ItemLabelGenerator.class.getSimpleName()));
        }
        return label;
    }

    private void scheduleRender() {
        if (this.renderScheduled || this.dataCommunicator == null || this.renderer == null) {
            return;
        }
        this.renderScheduled = true;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            Rendering rendering;
            if (this.dataGeneratorRegistration != null) {
                this.dataGeneratorRegistration.remove();
                this.dataGeneratorRegistration = null;
            }
            if ((rendering = this.renderer.render(this.getElement(), this.dataCommunicator.getKeyMapper(), this.template)).getDataGenerator().isPresent()) {
                this.dataGeneratorRegistration = this.dataGenerator.addDataGenerator((DataGenerator)rendering.getDataGenerator().get());
            }
            this.reset();
        });
    }

    @ClientCallable
    private void confirmUpdate(int id) {
        this.dataCommunicator.confirmUpdate(id);
    }

    @ClientCallable
    private void setRequestedRange(int start, int length, String filter) {
        this.lastFilter = filter;
        this.dataCommunicator.setRequestedRange(start, length);
        this.filterSlot.accept((Object)filter);
    }

    @ClientCallable
    private void resetDataCommunicator() {
        this.dataCommunicator.reset();
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void initConnector() {
        ((UI)this.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached ComboBox"))).getPage().executeJavaScript("window.Vaadin.Flow.comboBoxConnector.initLazy($0)", new Serializable[]{this.getElement()});
    }

    private DataKeyMapper<T> getKeyMapper() {
        return this.dataCommunicator.getKeyMapper();
    }

    private void setClientSideFilter(boolean clientSideFilter) {
        this.getElement().setProperty("_clientSideFilter", clientSideFilter);
    }

    private void reset() {
        if (this.dataCommunicator != null) {
            this.dataCommunicator.setRequestedRange(0, 0);
            this.dataCommunicator.reset();
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJavaScript("if($0.$connector) $0.$connector.reset();", new Serializable[]{this.getElement()}));
    }

    private static enum UserProvidedFilter {
        UNDECIDED,
        YES,
        NO;

    }

    @FunctionalInterface
    public static interface ItemFilter<T>
    extends SerializableBiPredicate<T, String> {
        public boolean test(T var1, String var2);
    }

    private final class UpdateQueue
    implements ArrayUpdater.Update {
        private List<Runnable> queue = new ArrayList<Runnable>();

        private UpdateQueue(int size) {
            this.enqueue("$connector.updateSize", Integer.valueOf(size));
        }

        public void set(int start, List<JsonValue> items) {
            this.enqueue("$connector.set", new Serializable[]{Integer.valueOf(start), (Serializable)items.stream().collect(JsonUtils.asArray()), ComboBox.this.lastFilter});
        }

        public void clear(int start, int length) {
        }

        public void commit(int updateId) {
            this.enqueue("$connector.confirm", new Serializable[]{Integer.valueOf(updateId), ComboBox.this.lastFilter});
            this.queue.forEach(Runnable::run);
            this.queue.clear();
            ComboBox.this.lastFilter = null;
        }

        private void enqueue(String name, Serializable ... arguments) {
            this.queue.add(() -> ComboBox.this.getElement().callFunction(name, arguments));
        }
    }

    private class CustomValueRegistration
    implements Registration {
        private Registration delegate;

        private CustomValueRegistration(Registration delegate) {
            this.delegate = delegate;
        }

        public void remove() {
            if (this.delegate != null) {
                this.delegate.remove();
                ComboBox.this.customValueListenersCount--;
                if (ComboBox.this.customValueListenersCount == 0) {
                    ComboBox.this.setAllowCustomValue(false);
                }
                this.delegate = null;
            }
        }
    }

    @FunctionalInterface
    public static interface FetchItemsCallback<T>
    extends Serializable {
        public Stream<T> fetchItems(String var1, int var2, int var3);
    }
}

