/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datetimepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerDatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerTimePicker;
import com.vaadin.flow.component.datetimepicker.FieldValidationUtil;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;

@Tag(value="vaadin-date-time-picker")
@HtmlImport(value="frontend://bower_components/vaadin-date-time-picker/src/vaadin-date-time-picker.html")
@NpmPackage(value="@vaadin/vaadin-date-time-picker", version="1.2.0")
@JsModule(value="@vaadin/vaadin-date-time-picker/src/vaadin-date-time-picker.js")
public class DateTimePicker
extends AbstractField<DateTimePicker, LocalDateTime>
implements HasStyle,
HasSize,
HasTheme,
HasValidation,
Focusable<DateTimePicker> {
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private final DateTimePickerDatePicker datePicker = new DateTimePickerDatePicker();
    private final DateTimePickerTimePicker timePicker = new DateTimePickerTimePicker();
    private DatePicker.DatePickerI18n i18n;
    private Locale locale;
    private static final SerializableFunction<String, LocalDateTime> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDateTime.parse(s);
    private static final SerializableFunction<LocalDateTime, String> FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.truncatedTo(ChronoUnit.MILLIS).toString();
    private LocalDateTime max;
    private LocalDateTime min;
    private boolean required;

    public DateTimePicker() {
        this((LocalDateTime)null);
    }

    public DateTimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public DateTimePicker(String label, LocalDateTime initialDateTime) {
        this(initialDateTime);
        this.setLabel(label);
    }

    public DateTimePicker(LocalDateTime initialDateTime) {
        super(null);
        if (initialDateTime != null) {
            this.setPresentationValue(initialDateTime);
            this.updateValue();
        }
        this.addToSlot((Component)this.datePicker, "date-picker");
        this.addToSlot((Component)this.timePicker, "time-picker");
        this.setLocale(UI.getCurrent().getLocale());
        this.setInvalid(false);
        this.getElement().addEventListener("value-changed", (DomEventListener & Serializable)e -> this.updateValue());
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        FieldValidationUtil.disableClientValidation((Component)this);
    }

    public DateTimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(initialDateTime);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(String label, LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(initialDateTime);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(LocalDateTime initialDateTime, Locale locale) {
        this(initialDateTime);
        this.setLocale(locale);
    }

    public void setValue(LocalDateTime value) {
        super.setValue((Object)value);
        this.getElement().executeJs("return this.value;", new Serializable[0]).then((SerializableConsumer & Serializable)jsonValue -> super.setValue(jsonValue.asString().isEmpty() ? null : LocalDateTime.parse(jsonValue.asString())));
    }

    protected void setPresentationValue(LocalDateTime newPresentationValue) {
        this.datePicker.setValue(newPresentationValue != null ? newPresentationValue.toLocalDate() : null);
        this.timePicker.setValue(newPresentationValue != null ? newPresentationValue.toLocalTime() : null);
        this.datePicker.getElement().executeJs("this.dispatchEvent(new CustomEvent('change', { bubbles: true }));", new Serializable[0]);
    }

    private void updateValue() {
        LocalDate date = (LocalDate)this.datePicker.getValue();
        LocalTime time = (LocalTime)this.timePicker.getValue();
        LocalDateTime newValue = date != null && time != null ? LocalDateTime.of(date, time) : null;
        this.setModelValue(newValue, true);
    }

    private void addToSlot(Component component, String slot) {
        Objects.requireNonNull(component, "Component to add cannot be null");
        component.getElement().setAttribute("slot", slot);
        this.getElement().appendChild(new Element[]{component.getElement()});
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.datePicker.setReadOnly(readOnly);
        this.timePicker.setReadOnly(readOnly);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setDatePlaceholder(String placeholder) {
        this.datePicker.setPlaceholder(placeholder);
    }

    public String getDatePlaceholder() {
        return this.datePicker.getPlaceholder();
    }

    public void setTimePlaceholder(String placeholder) {
        this.timePicker.setPlaceholder(placeholder);
    }

    public String getTimePlaceholder() {
        return this.timePicker.getPlaceholder();
    }

    public void setStep(Duration step) {
        this.timePicker.setStep(step);
    }

    public Duration getStep() {
        return this.timePicker.getStep();
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.datePicker.setWeekNumbersVisible(weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.datePicker.isWeekNumbersVisible();
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.datePicker.setLocale(locale);
        this.timePicker.setLocale(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void synchronizeTheme() {
        String theme = this.getThemeName();
        theme = theme != null ? theme : "";
        this.datePicker.getElement().setAttribute("theme", theme);
        this.timePicker.getElement().setAttribute("theme", theme);
    }

    public void addThemeName(String themeName) {
        super.addThemeName(themeName);
        this.synchronizeTheme();
    }

    public boolean removeThemeName(String themeName) {
        boolean result = super.removeThemeName(themeName);
        this.synchronizeTheme();
        return result;
    }

    public void setThemeName(String themeName) {
        super.setThemeName(themeName);
        this.synchronizeTheme();
    }

    public void setThemeName(String themeName, boolean set) {
        super.setThemeName(themeName, set);
        this.synchronizeTheme();
    }

    public void addThemeNames(String ... themeNames) {
        super.addThemeNames(themeNames);
        this.synchronizeTheme();
    }

    public void removeThemeNames(String ... themeNames) {
        super.removeThemeNames(themeNames);
        this.synchronizeTheme();
    }

    public void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage == null ? "" : errorMessage);
    }

    public String getErrorMessage() {
        return this.getElement().getProperty("error-message");
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    public boolean isInvalid() {
        return this.getElement().getProperty("invalid", false);
    }

    private boolean isInvalid(LocalDateTime value) {
        boolean isRequiredButEmpty = this.required && Objects.equals(this.getEmptyValue(), value);
        boolean isGreaterThanMax = value != null && this.max != null && value.isAfter(this.max);
        boolean isSmallerThanMin = value != null && this.min != null && value.isBefore(this.min);
        return isRequiredButEmpty || isGreaterThanMax || isSmallerThanMin;
    }

    protected void validate() {
        this.setInvalid(this.isInvalid((LocalDateTime)this.getValue()));
    }

    public void setMin(LocalDateTime min) {
        this.getElement().setProperty("min", (String)FORMATTER.apply((Object)min));
        this.min = min;
    }

    public LocalDateTime getMin() {
        return (LocalDateTime)PARSER.apply((Object)this.getElement().getProperty("min"));
    }

    public void setMax(LocalDateTime max) {
        this.getElement().setProperty("max", (String)FORMATTER.apply((Object)max));
        this.max = max;
    }

    public LocalDateTime getMax() {
        return (LocalDateTime)PARSER.apply((Object)this.getElement().getProperty("max"));
    }

    public DatePicker.DatePickerI18n getDatePickerI18n() {
        return this.i18n;
    }

    public void setDatePickerI18n(DatePicker.DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.i18n = i18n;
        this.datePicker.setI18n(i18n);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
        this.datePicker.setAutoOpen(autoOpen);
        this.timePicker.setAutoOpen(autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }
}

