/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.ValueProvider;

public class TextRenderer<ITEM>
extends BasicRenderer<ITEM, ITEM> {
    private final ItemLabelGenerator<ITEM> itemLabelGenerator;

    public TextRenderer() {
        this(String::valueOf);
    }

    public TextRenderer(ItemLabelGenerator<ITEM> itemLabelGenerator) {
        super(ValueProvider.identity());
        this.itemLabelGenerator = itemLabelGenerator;
    }

    @Override
    public Component createComponent(ITEM item) {
        String text = this.getFormattedValue(item);
        if (text == null) {
            throw new IllegalStateException(String.format("Got 'null' as a label value for the item '%s'. '%s' instance may not return 'null' values", item, ItemLabelGenerator.class.getSimpleName()));
        }
        return new TextRendererComponent(this.createElement(text));
    }

    protected Element createElement(String item) {
        return new Element("span").setText(item);
    }

    @Override
    protected String getFormattedValue(ITEM item) {
        return this.itemLabelGenerator.apply(item);
    }

    @Override
    protected String getTemplateExpression() {
        return "<span>${item.label}</span>";
    }

    private static class TextRendererComponent
    extends Component {
        TextRendererComponent(Element element) {
            super(element);
        }
    }
}

