/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import java.io.Serializable;

final class RequiredValidationUtil {
    RequiredValidationUtil() {
    }

    static void attachConnector(Component component) {
        RequiredValidationUtil.execJS(component, "window.Vaadin.Flow.textConnector = {\n        disableClientValidation: function (textComponent){\n            if ( typeof textComponent.$checkValidity == 'undefined'){\n                textComponent.$checkValidity = textComponent.checkValidity;\n                textComponent.checkValidity = function() { return true; };\n            }\n              if ( typeof textComponent.$validate == 'undefined'){\n                textComponent.$validate = textComponent.validate;\n                textComponent.validate = function() { return true; };\n            }\n  },\n        enableClientValidation: function (textComponent){\n            if ( textComponent.$checkValidity ){\n                textComponent.checkValidity = textComponent.$checkValidity;\n                delete textComponent.$checkValidity;\n            }\n              if ( textComponent.$validate ){\n                textComponent.validate = textComponent.$validate;\n                delete textComponent.$validate;\n            }\n  }\n }");
    }

    static void updateClientValidation(boolean requiredIndicatorVisible, Component component) {
        if (requiredIndicatorVisible) {
            RequiredValidationUtil.disableClientValiation(component);
        } else {
            RequiredValidationUtil.enableClientValiation(component);
        }
    }

    static void disableClientValiation(Component component) {
        RequiredValidationUtil.execJS(component, "window.Vaadin.Flow.textConnector.disableClientValidation($0);");
    }

    static void enableClientValiation(Component component) {
        RequiredValidationUtil.execJS(component, "window.Vaadin.Flow.textConnector.enableClientValidation($0);");
    }

    private static void execJS(Component component, String js) {
        StateNode node = component.getElement().getNode();
        node.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(node, (SerializableConsumer & Serializable)context -> ui.getPage().executeJavaScript(js, new Serializable[]{component.getElement()})));
    }
}

