/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.clone;

import com.alee.api.clone.AbstractRecursiveClone;
import com.alee.api.clone.CloneException;
import com.alee.api.clone.GlobalCloneBehavior;
import com.alee.api.clone.UnknownResolver;
import com.alee.api.clone.behavior.ArrayCloneBehavior;
import com.alee.api.clone.behavior.BasicCloneBehavior;
import com.alee.api.clone.behavior.CloneableCloneBehavior;
import com.alee.api.clone.behavior.CollectionCloneBehavior;
import com.alee.api.clone.behavior.MapCloneBehavior;
import com.alee.api.clone.behavior.RedefinedCloneBehavior;
import com.alee.api.clone.behavior.ReflectionCloneBehavior;
import com.alee.api.clone.behavior.SetCloneBehavior;
import com.alee.api.clone.unknownresolver.ExceptionUnknownResolver;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.reflection.ModifierType;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Clone
implements Serializable {
    private static Map<String, Clone> commons;
    private final UnknownResolver unknownResolver;
    private final List<GlobalCloneBehavior> behaviors;

    public Clone(UnknownResolver unknownResolver, GlobalCloneBehavior ... behaviors) {
        this(unknownResolver, new ImmutableList<GlobalCloneBehavior>(behaviors));
    }

    public Clone(UnknownResolver unknownResolver, List<GlobalCloneBehavior> behaviors) {
        this.unknownResolver = unknownResolver;
        this.behaviors = behaviors instanceof ImmutableList ? behaviors : new ImmutableList(behaviors);
    }

    public <T> T clone(T object) {
        return new InternalClone().clone(object, 0);
    }

    public static Clone basic() {
        String identifier = "basic";
        Clone clone = Clone.commonInstance("basic");
        if (clone == null) {
            clone = new Clone((UnknownResolver)new ExceptionUnknownResolver(), new BasicCloneBehavior(), new RedefinedCloneBehavior(), new ArrayCloneBehavior(), new MapCloneBehavior(), new SetCloneBehavior(), new CollectionCloneBehavior());
            commons.put("basic", clone);
        }
        return clone;
    }

    public static Clone deep() {
        String identifier = "deep";
        Clone clone = Clone.commonInstance("deep");
        if (clone == null) {
            clone = new Clone((UnknownResolver)new ExceptionUnknownResolver(), new BasicCloneBehavior(), new RedefinedCloneBehavior(), new ArrayCloneBehavior(), new MapCloneBehavior(), new SetCloneBehavior(), new CollectionCloneBehavior(), new ReflectionCloneBehavior(ReflectionCloneBehavior.Policy.cloneable, ModifierType.STATIC));
            commons.put("deep", clone);
        }
        return clone;
    }

    public static Clone adaptive() {
        String identifier = "adaptive";
        Clone clone = Clone.commonInstance("adaptive");
        if (clone == null) {
            clone = new Clone((UnknownResolver)new ExceptionUnknownResolver(), new BasicCloneBehavior(), new RedefinedCloneBehavior(), new ArrayCloneBehavior(), new MapCloneBehavior(), new SetCloneBehavior(), new CollectionCloneBehavior(), new CloneableCloneBehavior(), new ReflectionCloneBehavior(ReflectionCloneBehavior.Policy.cloneable, ModifierType.STATIC));
            commons.put("adaptive", clone);
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Clone commonInstance(String identifier) {
        if (commons != null) return commons.get(identifier);
        Class<Clone> clazz = Clone.class;
        synchronized (Clone.class) {
            if (commons != null) return commons.get(identifier);
            commons = new ConcurrentHashMap<String, Clone>(4);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return commons.get(identifier);
        }
    }

    private class InternalClone
    extends AbstractRecursiveClone {
        private InternalClone() {
        }

        @Override
        public <T> T clone(T object, int depth) {
            Object result;
            if (object != null) {
                Object cached = this.retrieve(object);
                if (cached == null) {
                    Object cloneResult = null;
                    GlobalCloneBehavior resultBehavior = null;
                    for (GlobalCloneBehavior behavior : Clone.this.behaviors) {
                        if (!behavior.supports(this, object)) continue;
                        cloneResult = behavior.clone(this, object, depth);
                        resultBehavior = behavior;
                        break;
                    }
                    if (resultBehavior != null) {
                        result = cloneResult;
                        if (depth > 0 && resultBehavior.isStorable()) {
                            this.store(object, result);
                        }
                    } else {
                        result = Clone.this.unknownResolver.resolve(this, object);
                        if (depth > 0) {
                            this.store(object, result);
                        }
                    }
                } else {
                    result = cached;
                }
            } else {
                result = null;
            }
            return (T)result;
        }

        @Override
        public <T> T cloneFields(T object, int depth) {
            for (GlobalCloneBehavior behavior : Clone.this.behaviors) {
                if (!(behavior instanceof ReflectionCloneBehavior)) continue;
                return behavior.clone(this, object, depth);
            }
            throw new CloneException("There is no ReflectionCloneBehavior in Clone algorithm");
        }
    }
}

