/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.clone.behavior;

import com.alee.api.clone.CloneException;
import com.alee.api.clone.GlobalCloneBehavior;
import com.alee.api.clone.RecursiveClone;
import java.lang.reflect.Array;

public class ArrayCloneBehavior
implements GlobalCloneBehavior<Object> {
    @Override
    public boolean supports(RecursiveClone clone, Object object) {
        return object.getClass().isArray();
    }

    @Override
    public Object clone(RecursiveClone clone, Object array, int depth) {
        try {
            Class<?> type = array.getClass().getComponentType();
            int length = Array.getLength(array);
            Object arrayCopy = Array.newInstance(type, length);
            if (length > 0) {
                clone.store(array, arrayCopy);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(array, i);
                    Object valueCopy = clone.clone(value, depth + 1);
                    Array.set(arrayCopy, i, valueCopy);
                }
            }
            return arrayCopy;
        }
        catch (Exception e) {
            throw new CloneException("Unable to instantiate array: " + array.getClass(), e);
        }
    }

    @Override
    public boolean isStorable() {
        return true;
    }
}

