/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.data;

import java.awt.ComponentOrientation;
import javax.swing.SwingConstants;

public enum CompassDirection implements SwingConstants
{
    center(0),
    northEast(2),
    north(1),
    northWest(8),
    east(3),
    west(7),
    southEast(4),
    south(5),
    southWest(6);

    private final int value;

    private CompassDirection(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public CompassDirection opposite() {
        switch (this) {
            case northEast: {
                return southWest;
            }
            case north: {
                return south;
            }
            case northWest: {
                return southEast;
            }
            case east: {
                return west;
            }
            case west: {
                return east;
            }
            case southEast: {
                return northWest;
            }
            case south: {
                return north;
            }
            case southWest: {
                return northEast;
            }
        }
        return center;
    }

    public CompassDirection adjust(ComponentOrientation orientation) {
        if (!orientation.isLeftToRight()) {
            switch (this) {
                case northEast: {
                    return northWest;
                }
                case northWest: {
                    return northEast;
                }
                case east: {
                    return west;
                }
                case west: {
                    return east;
                }
                case southEast: {
                    return southWest;
                }
                case southWest: {
                    return southEast;
                }
            }
            return this;
        }
        return this;
    }

    public static CompassDirection get(int value) {
        switch (value) {
            case 2: {
                return northEast;
            }
            case 1: {
                return north;
            }
            case 8: {
                return northWest;
            }
            case 3: {
                return east;
            }
            case 7: {
                return west;
            }
            case 4: {
                return southEast;
            }
            case 5: {
                return south;
            }
            case 6: {
                return southWest;
            }
        }
        return center;
    }
}

