/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;

public enum Rotation {
    none,
    clockwise,
    counterClockwise,
    upsideDown;


    public boolean isVertical() {
        return this == clockwise || this == counterClockwise;
    }

    public Rotation rightToLeft() {
        switch (this) {
            case clockwise: {
                return counterClockwise;
            }
            case counterClockwise: {
                return clockwise;
            }
        }
        return this;
    }

    public Rectangle transpose(Rectangle rectangle) {
        return this.isVertical() ? new Rectangle(rectangle.x, rectangle.y, rectangle.height, rectangle.width) : new Rectangle(rectangle);
    }

    public Dimension transpose(Dimension dimension) {
        return this.isVertical() ? new Dimension(dimension.height, dimension.width) : new Dimension(dimension);
    }

    public Component.BaselineResizeBehavior adjust(Component.BaselineResizeBehavior behavior) {
        switch (this) {
            case clockwise: 
            case counterClockwise: {
                return Component.BaselineResizeBehavior.OTHER;
            }
            case upsideDown: {
                switch (behavior) {
                    case CONSTANT_ASCENT: {
                        return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
                    }
                    case CONSTANT_DESCENT: {
                        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                    }
                }
                return behavior;
            }
        }
        return behavior;
    }
}

