/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.duplicate;

import com.alee.api.duplicate.DuplicateResolver;
import com.alee.api.matcher.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractDuplicateResolver
implements DuplicateResolver {
    private final Matcher matcher;

    public AbstractDuplicateResolver(Matcher matcher) {
        this.matcher = matcher;
    }

    protected boolean hasDuplicates(Collection collection) {
        ArrayList checked = new ArrayList(collection.size());
        for (Object next : collection) {
            if (this.matcher.supports(next)) {
                for (Object previous : checked) {
                    if (!this.matcher.supports(previous) || !this.matcher.match(previous, next)) continue;
                    return true;
                }
            }
            checked.add(next);
        }
        return false;
    }

    protected Object firstDuplicate(Collection collection) {
        ArrayList checked = new ArrayList(collection.size());
        for (Object next : collection) {
            if (this.matcher.supports(next)) {
                for (Object previous : checked) {
                    if (!this.matcher.supports(previous) || !this.matcher.match(previous, next)) continue;
                    return next;
                }
            }
            checked.add(next);
        }
        return null;
    }

    protected Collection removeDuplicates(Collection collection) {
        ArrayList checked = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            boolean unique = true;
            if (this.matcher.supports(next)) {
                for (Object previous : checked) {
                    if (!this.matcher.supports(previous) || !this.matcher.match(previous, next)) continue;
                    unique = false;
                    iterator.remove();
                    break;
                }
            }
            if (!unique) continue;
            checked.add(next);
        }
        return collection;
    }
}

