/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.merge;

import com.alee.api.clone.Clone;
import com.alee.api.clone.CloneException;
import com.alee.api.matcher.IdentifiableMatcher;
import com.alee.api.merge.ClonePolicy;
import com.alee.api.merge.GlobalMergeBehavior;
import com.alee.api.merge.MergeException;
import com.alee.api.merge.NullResolver;
import com.alee.api.merge.Overwriting;
import com.alee.api.merge.RecursiveMerge;
import com.alee.api.merge.UnknownResolver;
import com.alee.api.merge.behavior.BasicMergeBehavior;
import com.alee.api.merge.behavior.IndexArrayMergeBehavior;
import com.alee.api.merge.behavior.ListMergeBehavior;
import com.alee.api.merge.behavior.MapMergeBehavior;
import com.alee.api.merge.behavior.MergeableMergeBehavior;
import com.alee.api.merge.behavior.ReflectionMergeBehavior;
import com.alee.api.merge.clonepolicy.PerformClonePolicy;
import com.alee.api.merge.clonepolicy.SkipClonePolicy;
import com.alee.api.merge.nullresolver.SkippingNullResolver;
import com.alee.api.merge.unknownresolver.ExceptionUnknownResolver;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.reflection.ModifierType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Merge
implements Serializable {
    private static Map<String, Merge> commons;
    private final Clone clone;
    private final ClonePolicy baseClonePolicy;
    private final ClonePolicy mergedClonePolicy;
    private final NullResolver nullResolver;
    private final UnknownResolver unknownResolver;
    private final List<GlobalMergeBehavior> behaviors;

    public Merge(NullResolver nullResolver, UnknownResolver unknownResolver, GlobalMergeBehavior ... behaviors) {
        this(null, (ClonePolicy)new SkipClonePolicy(), (ClonePolicy)new SkipClonePolicy(), nullResolver, unknownResolver, new ImmutableList<GlobalMergeBehavior>(behaviors));
    }

    public Merge(Clone clone, ClonePolicy baseClonePolicy, ClonePolicy mergedClonePolicy, NullResolver nullResolver, UnknownResolver unknownResolver, GlobalMergeBehavior ... behaviors) {
        this(clone, baseClonePolicy, mergedClonePolicy, nullResolver, unknownResolver, new ImmutableList<GlobalMergeBehavior>(behaviors));
    }

    public Merge(NullResolver nullResolver, UnknownResolver unknownResolver, List<GlobalMergeBehavior> behaviors) {
        this(null, (ClonePolicy)new SkipClonePolicy(), (ClonePolicy)new SkipClonePolicy(), nullResolver, unknownResolver, behaviors);
    }

    public Merge(Clone clone, ClonePolicy baseClonePolicy, ClonePolicy mergedClonePolicy, NullResolver nullResolver, UnknownResolver unknownResolver, List<GlobalMergeBehavior> behaviors) {
        this.clone = clone;
        this.baseClonePolicy = baseClonePolicy;
        this.mergedClonePolicy = mergedClonePolicy;
        this.nullResolver = nullResolver;
        this.unknownResolver = unknownResolver;
        this.behaviors = behaviors instanceof ImmutableList ? behaviors : new ImmutableList(behaviors);
    }

    public <T> T merge(Object base, Object merged) {
        Object baseCopy = this.cloneBase(base);
        Object mergedCopy = this.cloneMerged(merged);
        InternalMerge internalMerge = new InternalMerge();
        return internalMerge.merge(Object.class, baseCopy, mergedCopy, 0);
    }

    public <T> T merge(Object base, Object merged, Object ... more) {
        Object baseCopy = this.cloneBase(base);
        Object mergedCopy = this.cloneMerged(merged);
        InternalMerge internalMerge = new InternalMerge();
        Object result = internalMerge.merge(Object.class, baseCopy, mergedCopy, 0);
        for (Object another : more) {
            Object anotherCopy = this.cloneMerged(another);
            result = internalMerge.merge(Object.class, result, anotherCopy, 0);
        }
        return result;
    }

    public <T> T merge(Collection<?> objects) {
        if (objects.size() > 0) {
            Iterator<?> iterator = objects.iterator();
            InternalMerge internalMerge = new InternalMerge();
            Object result = this.cloneBase(iterator.next());
            while (iterator.hasNext()) {
                Object mergedCopy = this.cloneMerged(iterator.next());
                result = internalMerge.merge(Object.class, result, mergedCopy, 0);
            }
            return (T)result;
        }
        throw new MergeException("At least one object must be specified for merge operation");
    }

    private Object cloneBase(Object base) {
        return this.baseClonePolicy.clone(this.clone, base);
    }

    private Object cloneMerged(Object merged) {
        return this.mergedClonePolicy.clone(this.clone, merged);
    }

    public static Merge basic() {
        String identifier = "basic";
        Merge merge = Merge.commonInstance("basic");
        if (merge == null) {
            merge = new Merge(Clone.deep(), (ClonePolicy)new PerformClonePolicy(), (ClonePolicy)new PerformClonePolicy(), (NullResolver)new SkippingNullResolver(), (UnknownResolver)new ExceptionUnknownResolver(), new BasicMergeBehavior(), new MergeableMergeBehavior(), new IndexArrayMergeBehavior(), new MapMergeBehavior(), new ListMergeBehavior(new IdentifiableMatcher()));
            commons.put("basic", merge);
        }
        return merge;
    }

    public static Merge basicRaw() {
        String identifier = "basicRaw";
        Merge merge = Merge.commonInstance("basicRaw");
        if (merge == null) {
            merge = new Merge((NullResolver)new SkippingNullResolver(), (UnknownResolver)new ExceptionUnknownResolver(), new BasicMergeBehavior(), new MergeableMergeBehavior(), new IndexArrayMergeBehavior(), new MapMergeBehavior(), new ListMergeBehavior(new IdentifiableMatcher()));
            commons.put("basicRaw", merge);
        }
        return merge;
    }

    public static Merge deep() {
        String identifier = "deep";
        Merge merge = Merge.commonInstance("deep");
        if (merge == null) {
            merge = new Merge(Clone.deep(), (ClonePolicy)new PerformClonePolicy(), (ClonePolicy)new PerformClonePolicy(), (NullResolver)new SkippingNullResolver(), (UnknownResolver)new ExceptionUnknownResolver(), new BasicMergeBehavior(), new MergeableMergeBehavior(), new IndexArrayMergeBehavior(), new MapMergeBehavior(), new ListMergeBehavior(new IdentifiableMatcher()), new ReflectionMergeBehavior(ReflectionMergeBehavior.Policy.mergeable, ModifierType.STATIC));
            commons.put("deep", merge);
        }
        return merge;
    }

    public static Merge deepRaw() {
        String identifier = "deepRaw";
        Merge merge = Merge.commonInstance("deepRaw");
        if (merge == null) {
            merge = new Merge((NullResolver)new SkippingNullResolver(), (UnknownResolver)new ExceptionUnknownResolver(), new BasicMergeBehavior(), new MergeableMergeBehavior(), new IndexArrayMergeBehavior(), new MapMergeBehavior(), new ListMergeBehavior(new IdentifiableMatcher()), new ReflectionMergeBehavior(ReflectionMergeBehavior.Policy.mergeable, ModifierType.STATIC));
            commons.put("deepRaw", merge);
        }
        return merge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Merge commonInstance(String identifier) {
        if (commons != null) return commons.get(identifier);
        Class<Merge> clazz = Merge.class;
        synchronized (Merge.class) {
            if (commons != null) return commons.get(identifier);
            commons = new ConcurrentHashMap<String, Merge>(4);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return commons.get(identifier);
        }
    }

    private class InternalMerge
    implements RecursiveMerge {
        private InternalMerge() {
        }

        @Override
        public Object overwrite(Object base, Object merged) {
            if (base != null && merged != null) {
                return merged;
            }
            return Merge.this.nullResolver.resolve(this, base, merged);
        }

        @Override
        public <T> T merge(Class type, Object base, Object merged, int depth) {
            Object result;
            if (base != null && merged != null) {
                if (!(merged instanceof Overwriting) || !((Overwriting)merged).isOverwrite()) {
                    Object mergeResult = null;
                    for (GlobalMergeBehavior behavior : Merge.this.behaviors) {
                        if (!behavior.supports(this, type, base, merged)) continue;
                        mergeResult = behavior.merge(this, type, base, merged, depth);
                        break;
                    }
                    result = mergeResult != null ? mergeResult : Merge.this.unknownResolver.resolve(this, base, merged);
                } else {
                    result = merged;
                }
            } else {
                result = Merge.this.nullResolver.resolve(this, base, merged);
            }
            return (T)result;
        }

        @Override
        public <T> T mergeFields(Class type, Object base, Object merged, int depth) {
            for (GlobalMergeBehavior behavior : Merge.this.behaviors) {
                if (!(behavior instanceof ReflectionMergeBehavior)) continue;
                return (T)behavior.merge(this, type, base, merged, depth);
            }
            throw new CloneException("There is no ReflectionMergeBehavior in Merge algorithm");
        }
    }
}

