/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.merge.behavior;

import com.alee.api.merge.GlobalMergeBehavior;
import com.alee.api.merge.MergeException;
import com.alee.api.merge.RecursiveMerge;
import com.alee.utils.ReflectUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class BasicMergeBehavior
implements GlobalMergeBehavior<Object, Object, Object> {
    @Override
    public boolean supports(RecursiveMerge merge, Class<Object> type, Object base, Object merged) {
        return (this.isBasic(base) || this.isBasic(merged)) && base.getClass() == merged.getClass();
    }

    @Override
    public Object merge(RecursiveMerge merge, Class type, Object base, Object merged, int depth) {
        if (this.isSimpleMutable(merged)) {
            Class<?> clazz = merged.getClass();
            if (clazz == Insets.class) {
                Insets m = (Insets)merged;
                return new Insets(m.top, m.left, m.bottom, m.right);
            }
            if (clazz == Dimension.class) {
                Dimension m = (Dimension)merged;
                return new Dimension(m.width, m.height);
            }
            if (clazz == Point.class) {
                Point m = (Point)merged;
                return new Point(m.x, m.y);
            }
            if (clazz == Point2D.Float.class) {
                Point2D.Float m = (Point2D.Float)merged;
                return new Point2D.Float(m.x, m.y);
            }
            if (clazz == Point2D.Double.class) {
                Point2D.Double m = (Point2D.Double)merged;
                return new Point2D.Double(m.x, m.y);
            }
            if (clazz == Line2D.Float.class) {
                Line2D.Float m = (Line2D.Float)merged;
                return new Line2D.Float(m.x1, m.y1, m.x2, m.y2);
            }
            if (clazz == Line2D.Double.class) {
                Line2D.Double m = (Line2D.Double)merged;
                return new Line2D.Double(m.x1, m.y1, m.x2, m.y2);
            }
            if (clazz == Rectangle.class) {
                Rectangle m = (Rectangle)merged;
                return new Rectangle(m.x, m.y, m.width, m.height);
            }
            if (clazz == Rectangle2D.Float.class) {
                Rectangle2D.Float m = (Rectangle2D.Float)merged;
                return new Rectangle2D.Float(m.x, m.y, m.width, m.height);
            }
            if (clazz == Rectangle2D.Double.class) {
                Rectangle2D.Double m = (Rectangle2D.Double)merged;
                return new Rectangle2D.Double(m.x, m.y, m.width, m.height);
            }
            if (clazz == Ellipse2D.Float.class) {
                Ellipse2D.Float m = (Ellipse2D.Float)merged;
                return new Ellipse2D.Float(m.x, m.y, m.width, m.height);
            }
            if (clazz == Ellipse2D.Double.class) {
                Ellipse2D.Double m = (Ellipse2D.Double)merged;
                return new Ellipse2D.Double(m.x, m.y, m.width, m.height);
            }
            if (clazz == AtomicBoolean.class) {
                AtomicBoolean ab = (AtomicBoolean)merged;
                return new AtomicBoolean(ab.get());
            }
            if (clazz == AtomicInteger.class) {
                AtomicInteger ai = (AtomicInteger)merged;
                return new AtomicInteger(ai.get());
            }
            if (clazz == AtomicLong.class) {
                AtomicLong al = (AtomicLong)merged;
                return new AtomicLong(al.get());
            }
            throw new MergeException("Unsupported mutable type merge requested: " + clazz);
        }
        return merged;
    }

    private boolean isBasic(Object object) {
        return ReflectUtils.isPrimitive(object) || this.isSimpleImmutable(object) || this.isSimpleMutable(object);
    }

    private boolean isSimpleImmutable(Object object) {
        Class<?> clazz = object.getClass();
        return clazz.isEnum() || clazz == Class.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == Date.class || clazz == Color.class || clazz == Font.class || clazz == BasicStroke.class || clazz == File.class;
    }

    private boolean isSimpleMutable(Object object) {
        Class<?> clazz = object.getClass();
        return clazz == Insets.class || Dimension2D.class.isAssignableFrom(clazz) || Point2D.class.isAssignableFrom(clazz) || Line2D.class.isAssignableFrom(clazz) || Rectangle2D.class.isAssignableFrom(clazz) || Ellipse2D.class.isAssignableFrom(clazz) || clazz == AtomicBoolean.class || clazz == AtomicInteger.class || clazz == AtomicLong.class;
    }
}

