/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.merge.behavior;

import com.alee.api.duplicate.DuplicateResolver;
import com.alee.api.duplicate.RejectDuplicates;
import com.alee.api.matcher.Matcher;
import com.alee.api.merge.GlobalMergeBehavior;
import com.alee.api.merge.MergeException;
import com.alee.api.merge.RecursiveMerge;
import java.util.Collection;
import java.util.List;

public class ListMergeBehavior<T extends List>
implements GlobalMergeBehavior<T, T, T> {
    private final Matcher matcher;
    private final DuplicateResolver baseDuplicateResolver;
    private final DuplicateResolver mergedDuplicateResolver;

    public ListMergeBehavior(Matcher matcher) {
        this(matcher, new RejectDuplicates(matcher), new RejectDuplicates(matcher));
    }

    public ListMergeBehavior(Matcher matcher, DuplicateResolver baseDuplicateResolver, DuplicateResolver mergedDuplicateResolver) {
        this.matcher = matcher;
        this.baseDuplicateResolver = baseDuplicateResolver;
        this.mergedDuplicateResolver = mergedDuplicateResolver;
    }

    @Override
    public boolean supports(RecursiveMerge merge, Class<T> type, Object base, Object merged) {
        return base instanceof List && merged instanceof List;
    }

    @Override
    public T merge(RecursiveMerge merge, Class type, T base, T merged, int depth) {
        this.baseDuplicateResolver.resolve((Collection)base);
        this.mergedDuplicateResolver.resolve((Collection)merged);
        for (Object mergedObject : merged) {
            if (mergedObject != null) {
                if (this.matcher.supports(mergedObject)) {
                    boolean matched = false;
                    for (int j = 0; j < base.size(); ++j) {
                        Object baseObject = base.get(j);
                        if (baseObject != null) {
                            if (!this.matcher.supports(baseObject) || !this.matcher.match(mergedObject, baseObject)) continue;
                            base.set(j, merge.merge(Object.class, baseObject, mergedObject, depth + 1));
                            matched = true;
                            break;
                        }
                        throw new MergeException("Base list contains null element(s)");
                    }
                    if (matched) continue;
                    base.add(mergedObject);
                    continue;
                }
                if (mergedObject == null) continue;
                base.add(mergedObject);
                continue;
            }
            throw new MergeException("Merged list contains null element(s)");
        }
        return base;
    }
}

