/*
 * Decompiled with CFR 0.152.
 */
package com.alee.api.merge.behavior;

import com.alee.api.merge.GlobalMergeBehavior;
import com.alee.api.merge.MergeException;
import com.alee.api.merge.Mergeable;
import com.alee.api.merge.RecursiveMerge;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.api.merge.behavior.OverwriteOnMerge;
import com.alee.api.merge.behavior.PreserveOnMerge;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.reflection.ClassRelationType;
import com.alee.utils.reflection.ModifierType;
import java.lang.reflect.Field;
import java.util.List;

public class ReflectionMergeBehavior
implements GlobalMergeBehavior<Object, Object, Object> {
    private final Policy policy;
    private final List<ModifierType> ignoredModifiers;

    public ReflectionMergeBehavior(Policy policy, ModifierType ... ignoredModifiers) {
        this.policy = policy;
        this.ignoredModifiers = CollectionUtils.asList(ignoredModifiers);
    }

    @Override
    public boolean supports(RecursiveMerge merge, Class<Object> type, Object base, Object merged) {
        return (this.policy == Policy.all || base instanceof Mergeable && merged instanceof Mergeable) && type.isAssignableFrom(base.getClass()) && type.isAssignableFrom(merged.getClass());
    }

    @Override
    public Object merge(RecursiveMerge merge, Class type, Object base, Object merged, int depth) {
        Object result;
        ClassRelationType relation = ClassRelationType.of(base, merged);
        if (relation.isSame() || relation.isAncestor()) {
            List<Field> fields = ReflectUtils.getFields(merged.getClass());
            if (CollectionUtils.notEmpty(fields)) {
                for (Field field : fields) {
                    String message;
                    if (!ReflectUtils.hasNoneOfModifiers(field, this.ignoredModifiers)) continue;
                    Class<?> fieldType = field.getType();
                    if (field.getAnnotation(OmitOnMerge.class) != null) {
                        try {
                            Object value = fieldType.isPrimitive() ? ReflectUtils.getDefaultPrimitiveValue(fieldType) : null;
                            ReflectUtils.setFieldValue(base, field, value);
                            continue;
                        }
                        catch (Exception e) {
                            message = "Unable to omit field {%s} value";
                            throw new MergeException(String.format("Unable to omit field {%s} value", field), e);
                        }
                    }
                    if (field.getAnnotation(PreserveOnMerge.class) != null) continue;
                    try {
                        Object baseValue = field.get(base);
                        Object mergedValue = field.get(merged);
                        Object mergeResult = field.getAnnotation(OverwriteOnMerge.class) == null ? merge.merge(fieldType, baseValue, mergedValue, depth + 1) : merge.overwrite(baseValue, mergedValue);
                        ReflectUtils.setFieldValue(base, field, mergeResult);
                    }
                    catch (Exception e) {
                        message = "Unable to merge field {%s} values for objects {%s} and {%s}";
                        throw new MergeException(String.format("Unable to merge field {%s} values for objects {%s} and {%s}", field, base, merged), e);
                    }
                }
            }
            result = base;
        } else {
            result = merged;
        }
        return result;
    }

    public static enum Policy {
        mergeable,
        all;

    }
}

