/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.api.jdk.Objects;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Value;
import com.alee.utils.TextUtils;
import java.io.Serializable;
import java.util.Locale;

public class Language
implements Serializable {
    protected final Locale locale;

    public Language(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Dictionary getDictionaries() {
        return LanguageManager.getDictionaries();
    }

    public Record getRecord(String key) {
        return TextUtils.notEmpty(key) ? this.getDictionaries().getRecord(key, this.locale) : null;
    }

    public Value getValue(String key) {
        Record record = this.getRecord(key);
        return record != null ? record.getValue(this.locale) : null;
    }

    public Text getText(String key) {
        Value value = this.getValue(key);
        return value != null ? value.getText() : null;
    }

    public Text getText(String key, String state) {
        Value value = this.getValue(key);
        return value != null ? value.getText(state) : null;
    }

    public String get(String key, Object ... data) {
        Text text = this.getText(key);
        return text != null ? text.getText(data) : key;
    }

    public String getState(String key, String state, Object ... data) {
        Text text = this.getText(key, state);
        return text != null ? text.getText(data) : key;
    }

    public int getMnemonic(String key) {
        Text text = this.getText(key);
        return text != null ? text.getMnemonic() : -1;
    }

    public int getMnemonic(String key, String state) {
        Text text = this.getText(key, state);
        return text != null ? text.getMnemonic() : -1;
    }

    public boolean contains(String key) {
        return this.getRecord(key) != null;
    }

    public boolean containsText(String key) {
        return this.getText(key) != null;
    }

    public boolean containsText(String key, String state) {
        return this.getText(key, state) != null;
    }

    public boolean equals(Object language) {
        return language instanceof Language && Objects.equals((Object)this.getLocale(), (Object)((Language)language).getLocale());
    }

    public String toString() {
        return "Language[" + this.locale.toString() + "]";
    }
}

