/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.api.jdk.Objects;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageException;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.TranslationInformation;
import com.alee.managers.language.data.Value;
import com.alee.utils.CollectionUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class LanguageManager {
    private static final Filter<Locale> SUPPORTED_LOCALES_FILTER = new Filter<Locale>(){

        @Override
        public boolean accept(Locale locale) {
            return LanguageManager.isSuportedLocale(locale);
        }
    };
    private static Language language;
    private static Dictionary dictionaries;
    private static final List<LanguageListener> languageListeners;
    private static final List<DictionaryListener> dictionaryListeners;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            XmlUtils.processAnnotations(Dictionary.class);
            XmlUtils.processAnnotations(TranslationInformation.class);
            XmlUtils.processAnnotations(Record.class);
            XmlUtils.processAnnotations(Value.class);
            XmlUtils.processAnnotations(Text.class);
            dictionaries = new Dictionary("", "Global dictionary");
            initialized = true;
            LanguageManager.addDictionary(new Dictionary(LanguageManager.class, "resources/core-language.xml"));
        }
    }

    private static void mustBeInitialized() throws LanguageException {
        if (!initialized) {
            throw new LanguageException("LanguageManager must be initialized first");
        }
    }

    public static String getLanguageTitle(Language language) {
        return LanguageManager.getLocaleTitle(language.getLocale());
    }

    public static String getLocaleTitle(Locale locale) {
        LanguageManager.mustBeInitialized();
        TranslationInformation info = dictionaries.getTranslation(locale);
        return info != null ? info.getTitle() : LanguageUtils.toString(locale);
    }

    public synchronized List<Locale> getAllLocales() {
        LanguageManager.mustBeInitialized();
        return dictionaries.getAllLocales();
    }

    public static List<Locale> getSupportedLocales() {
        LanguageManager.mustBeInitialized();
        return dictionaries.getSupportedLocales();
    }

    public static List<Locale> getSupportedLocales(List<Locale> locales) {
        LanguageManager.mustBeInitialized();
        return CollectionUtils.filter(locales, SUPPORTED_LOCALES_FILTER);
    }

    public static boolean isSuportedLanguage(Language language) {
        LanguageManager.mustBeInitialized();
        return LanguageManager.isSuportedLocale(language.getLocale());
    }

    public static boolean isSuportedLocale(Locale locale) {
        LanguageManager.mustBeInitialized();
        boolean supported = false;
        for (Locale slocale : dictionaries.getSupportedLocales()) {
            if (!Objects.equals((Object)locale.getLanguage(), (Object)slocale.getLanguage())) continue;
            supported = true;
            break;
        }
        return supported;
    }

    public static void addDictionary(Dictionary dictionary) {
        LanguageManager.mustBeInitialized();
        dictionaries.addDictionary(dictionary);
        LanguageManager.fireDictionaryAdded(dictionary);
    }

    public static void removeDictionary(Dictionary dictionary) {
        LanguageManager.mustBeInitialized();
        dictionaries.removeDictionary(dictionary);
        LanguageManager.fireDictionaryRemoved(dictionary);
    }

    public static void clearDictionaries() {
        LanguageManager.mustBeInitialized();
        dictionaries.clearRecords();
        dictionaries.clearDictionaries();
        LanguageManager.fireDictionariesCleared();
    }

    public static Dictionary getDictionaries() {
        LanguageManager.mustBeInitialized();
        return dictionaries;
    }

    public static Locale getLocale() {
        LanguageManager.mustBeInitialized();
        return LanguageManager.getLanguage().getLocale();
    }

    public static boolean isCurrentLocale(Locale locale) {
        LanguageManager.mustBeInitialized();
        return LanguageManager.getLanguage().getLocale().equals(locale);
    }

    public static void setLocale(Locale locale) {
        LanguageManager.mustBeInitialized();
        if (locale == null) {
            throw new LanguageException("Locale must be specified");
        }
        LanguageManager.setLanguage(new Language(locale));
    }

    public static Language getLanguage() {
        LanguageManager.mustBeInitialized();
        if (language == null) {
            List<Locale> locales;
            Locale locale = Locale.getDefault();
            language = LanguageManager.isSuportedLocale(locale) ? new Language(locale) : (!(locales = LanguageManager.getSupportedLocales()).isEmpty() ? new Language(locales.get(0)) : new Language(new Locale("en", "GB")));
        }
        return language;
    }

    public static boolean isCurrentLanguage(Language language) {
        LanguageManager.mustBeInitialized();
        return Objects.equals((Object)language, (Object)LanguageManager.getLanguage());
    }

    public static void setLanguage(Language language) {
        LanguageManager.mustBeInitialized();
        if (language == null) {
            throw new LanguageException("Language must be specified");
        }
        if (language.getLocale() == null) {
            throw new LanguageException("Locale must be specified");
        }
        if (!LanguageManager.isCurrentLanguage(language)) {
            Language oldLanguage = LanguageManager.getLanguage();
            LanguageManager.language = language;
            LanguageManager.fireLanguageChanged(oldLanguage, language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageListener(LanguageListener listener) {
        List<LanguageListener> list = languageListeners;
        synchronized (list) {
            languageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageListener(LanguageListener listener) {
        List<LanguageListener> list = languageListeners;
        synchronized (list) {
            languageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageChanged(Language oldLanguage, Language newLanguage) {
        List<LanguageListener> list = languageListeners;
        synchronized (list) {
            for (LanguageListener listener : CollectionUtils.copy(languageListeners)) {
                listener.languageChanged(oldLanguage, newLanguage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDictionaryListener(DictionaryListener listener) {
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            dictionaryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDictionaryListener(DictionaryListener listener) {
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            dictionaryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionaryAdded(Dictionary dictionary) {
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            for (DictionaryListener listener : CollectionUtils.copy(dictionaryListeners)) {
                listener.dictionaryAdded(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionaryRemoved(Dictionary dictionary) {
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            for (DictionaryListener listener : CollectionUtils.copy(dictionaryListeners)) {
                listener.dictionaryRemoved(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionariesCleared() {
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            for (DictionaryListener listener : CollectionUtils.copy(dictionaryListeners)) {
                listener.dictionariesCleared();
            }
        }
    }

    static {
        languageListeners = new ArrayList<LanguageListener>();
        dictionaryListeners = new ArrayList<DictionaryListener>();
        initialized = false;
    }
}

