/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.managers.language.LanguageException;
import com.alee.utils.TextUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LanguageUtils {
    private static final Map<String, Locale> localesCache = new HashMap<String, Locale>(5);
    private static final String COUNTRY_SEPARATOR = "-";

    public static String toString(Locale locale) {
        if (locale != null) {
            String lang = (locale.getLanguage() != null ? locale.getLanguage() : "").toLowerCase(Locale.ROOT);
            String country = (locale.getCountry() != null ? locale.getCountry() : "").toUpperCase(Locale.ROOT);
            return lang + (TextUtils.notEmpty(country) ? COUNTRY_SEPARATOR + country : "");
        }
        throw new LanguageException("Locale was not specified");
    }

    public static Locale fromString(String locale) {
        if (locale != null) {
            int s = locale.indexOf(COUNTRY_SEPARATOR);
            String lang = (s != -1 ? locale.substring(0, s) : locale).toLowerCase(Locale.ROOT);
            String country = (s != -1 ? locale.substring(s + COUNTRY_SEPARATOR.length()) : "").toUpperCase(Locale.ROOT);
            String key = lang + (TextUtils.notEmpty(country) ? COUNTRY_SEPARATOR + country : "");
            if (!localesCache.containsKey(key)) {
                localesCache.put(key, new Locale(lang, country));
            }
            return localesCache.get(key);
        }
        throw new LanguageException("Locale was not specified");
    }

    public static Locale getSystemLocale() {
        String language = System.getProperty("user.language");
        if (TextUtils.notEmpty(language)) {
            String country = System.getProperty("user.country");
            String variant = System.getProperty("user.variant");
            return new Locale(language, TextUtils.notEmpty(country) ? country : "", TextUtils.notEmpty(variant) ? variant : "");
        }
        return new Locale("en", "US");
    }
}

