/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.api.jdk.Objects;
import com.alee.utils.TextUtils;
import java.util.Comparator;
import java.util.Locale;

public abstract class AbstractCountryComparator<T>
implements Comparator<T> {
    protected final Locale locale;

    public AbstractCountryComparator(Locale locale) {
        this.locale = locale;
    }

    protected int compareCountries(String country1, String country2) {
        if (TextUtils.isEmpty(this.locale.getCountry())) {
            return this.noCountryPriority(country1, country2);
        }
        return this.sameCountryPriority(country1, country2);
    }

    protected int sameCountryPriority(String country1, String country2) {
        boolean same1 = Objects.equals((Object)this.locale.getCountry(), (Object)country1);
        boolean same2 = Objects.equals((Object)this.locale.getCountry(), (Object)country2);
        int result = same1 && !same2 ? 1 : (same2 && !same1 ? -1 : this.noCountryPriority(country1, country2));
        return result;
    }

    protected int noCountryPriority(String country1, String country2) {
        boolean has1 = TextUtils.notEmpty(country1);
        boolean has2 = TextUtils.notEmpty(country2);
        int result = !has1 && has2 ? 1 : (!has2 && has1 ? -1 : 0);
        return result;
    }
}

