/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.Mergeable;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.RecordCountryComparator;
import com.alee.managers.language.data.TranslationInformation;
import com.alee.managers.language.data.TranslationInformationComparator;
import com.alee.managers.language.data.Value;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.collection.ImmutableSet;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@XStreamAlias(value="Dictionary")
public final class Dictionary
implements Identifiable,
Mergeable,
Cloneable,
Serializable {
    private static final String ID_PREFIX = "DIC";
    private final transient String id = TextUtils.generateId("DIC");
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String prefix;
    @XStreamImplicit(itemFieldName="record")
    private List<Record> records;
    @XStreamImplicit(itemFieldName="Dictionary")
    private List<Dictionary> dictionaries;
    @XStreamAlias(value="Translations")
    private List<TranslationInformation> translations;
    private transient List<Locale> allLocales;
    private transient List<Locale> supportedLocales;
    private transient Map<String, Record> recordsCache;
    private transient Map<String, Dictionary> dictionariesCache;

    public Dictionary() {
        this((String)null, null);
    }

    public Dictionary(String prefix) {
        this(prefix, null);
    }

    public Dictionary(String prefix, String name) {
        this.prefix = prefix;
        this.name = name;
    }

    public Dictionary(Class nearClass, String resource) {
        XmlUtils.getXStream().fromXML(nearClass.getResourceAsStream(resource), (Object)this);
    }

    public Dictionary(URL url) {
        XmlUtils.getXStream().fromXML(url, (Object)this);
    }

    public Dictionary(File file) {
        XmlUtils.getXStream().fromXML(file, (Object)this);
    }

    public Dictionary(InputStream inputStream) {
        XmlUtils.getXStream().fromXML(inputStream, (Object)this);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public synchronized void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public synchronized int recordsCount() {
        return this.records != null ? this.records.size() : 0;
    }

    public synchronized int totalRecordsCount() {
        int count;
        int n = count = this.records != null ? this.records.size() : 0;
        if (CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary dictionary : this.dictionaries) {
                count += dictionary.totalRecordsCount();
            }
        }
        return count;
    }

    public synchronized List<Record> getRecords() {
        return this.records != null ? new ImmutableList<Record>((Collection<Record>)this.records) : new ImmutableList<Record>(new Record[0]);
    }

    public synchronized void setRecords(List<Record> records) {
        this.records = records;
    }

    public synchronized Record getRecord(String key, Locale locale) {
        Record result;
        String cacheKey = key + "." + LanguageUtils.toString(locale);
        if (this.recordsCache != null && this.recordsCache.containsKey(cacheKey)) {
            result = this.recordsCache.get(cacheKey);
        } else {
            String subKey;
            String dicPrefix = this.usablePrefix();
            String string = subKey = key.startsWith(dicPrefix) ? key.substring(dicPrefix.length()) : null;
            if (this.dictionariesCache != null && this.dictionariesCache.containsKey(cacheKey)) {
                result = this.dictionariesCache.get(cacheKey).getRecord(subKey, locale);
            } else if (subKey != null) {
                Record record = null;
                Dictionary source = this;
                RecordCountryComparator comparator = new RecordCountryComparator(locale);
                if (CollectionUtils.notEmpty(this.records)) {
                    List<Record> fitting = this.collectLocalRecords(subKey, new ArrayList<Record>(3));
                    record = CollectionUtils.max(fitting, comparator);
                }
                if (CollectionUtils.notEmpty(this.dictionaries)) {
                    for (Dictionary dictionary : this.dictionaries) {
                        Record subRecord = dictionary.getRecord(subKey, locale);
                        if (subRecord == null || record != null && comparator.compare(record, subRecord) <= 0) continue;
                        record = subRecord;
                        source = dictionary;
                    }
                }
                result = record;
                if (source == this) {
                    if (this.recordsCache == null) {
                        this.recordsCache = new HashMap<String, Record>(this.recordsCount());
                    }
                    this.recordsCache.put(cacheKey, result);
                } else {
                    if (this.dictionariesCache == null) {
                        this.dictionariesCache = new HashMap<String, Dictionary>(this.dictionariesCount() * 5);
                    }
                    this.dictionariesCache.put(cacheKey, source);
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    private synchronized List<Record> getRecords(String key) {
        return this.getRecords(key, new ArrayList<Record>());
    }

    private synchronized List<Record> getRecords(String key, List<Record> results) {
        String subKey;
        String dicPrefix = this.usablePrefix();
        String string = subKey = key.startsWith(dicPrefix) ? key.substring(dicPrefix.length()) : null;
        if (subKey != null) {
            this.collectLocalRecords(subKey, results);
            if (CollectionUtils.notEmpty(this.dictionaries)) {
                for (Dictionary dictionary : this.dictionaries) {
                    dictionary.getRecords(subKey, results);
                }
            }
        }
        return results;
    }

    private synchronized List<Record> collectLocalRecords(String key, List<Record> results) {
        if (CollectionUtils.notEmpty(this.records)) {
            for (Record record : this.records) {
                if (!Objects.equals((Object)record.getKey(), (Object)key)) continue;
                results.add(record);
            }
        }
        return results;
    }

    public synchronized Record addRecord(Record record) {
        if (this.records == null) {
            this.records = new ArrayList<Record>(1);
        }
        this.records.add(record);
        this.destroyRecordCaches(record);
        return record;
    }

    public synchronized void removeRecord(Record record) {
        if (this.records != null) {
            this.records.remove(record);
            this.destroyRecordCaches(record);
        }
    }

    public synchronized void removeRecord(String key) {
        if (CollectionUtils.notEmpty(this.records)) {
            Iterator<Record> iterator = this.records.iterator();
            while (iterator.hasNext()) {
                Record record = iterator.next();
                if (!record.getKey().equals(key)) continue;
                iterator.remove();
                this.destroyRecordCaches(record);
                break;
            }
        }
    }

    private void destroyRecordCaches(Record record) {
        this.clearLocaleCaches();
        if (this.recordsCache != null || this.dictionariesCache != null) {
            ImmutableSet<String> keys = new ImmutableSet<String>(record.getKey());
            if (this.recordsCache != null) {
                this.destroyKeys(this.recordsCache.keySet().iterator(), keys);
            }
            if (this.dictionariesCache != null) {
                this.destroyKeys(this.dictionariesCache.keySet().iterator(), keys);
            }
        }
    }

    public synchronized void clearRecords() {
        if (this.records != null) {
            this.records.clear();
            this.records = null;
            this.destroyRecordCaches();
        }
    }

    private void destroyRecordCaches() {
        this.clearLocaleCaches();
        if (this.recordsCache != null) {
            this.recordsCache.clear();
            this.recordsCache = null;
        }
    }

    public synchronized Set<String> getKeys() {
        return this.getKeys("");
    }

    private Set<String> getKeys(String prefix) {
        return this.collectKeys(prefix, new HashSet<String>(this.totalRecordsCount()));
    }

    private Set<String> collectKeys(String prefix, Set<String> keys) {
        String p = prefix + this.usablePrefix();
        if (this.records != null) {
            for (Record record : this.records) {
                keys.add(p + record.getKey());
            }
        }
        if (this.dictionaries != null) {
            for (Dictionary dictionary : this.dictionaries) {
                dictionary.collectKeys(p, keys);
            }
        }
        return keys;
    }

    public synchronized int dictionariesCount() {
        return this.dictionaries != null ? this.dictionaries.size() : 0;
    }

    public synchronized List<Dictionary> getDictionaries() {
        return this.dictionaries != null ? new ImmutableList<Dictionary>((Collection<Dictionary>)this.dictionaries) : new ImmutableList<Dictionary>(new Dictionary[0]);
    }

    public synchronized void setDictionaries(List<Dictionary> dictionaries) {
        this.dictionaries = dictionaries;
    }

    public synchronized void addDictionary(Dictionary dictionary) {
        if (this.dictionaries == null) {
            this.dictionaries = new ArrayList<Dictionary>();
        }
        this.dictionaries.add(dictionary);
        this.destroyDictionaryCaches(dictionary);
    }

    public synchronized void removeDictionary(Dictionary dictionary) {
        if (this.dictionaries != null) {
            this.dictionaries.remove(dictionary);
            this.destroyDictionaryCaches(dictionary);
        }
    }

    private void destroyDictionaryCaches(Dictionary dictionary) {
        this.clearLocaleCaches();
        if (this.recordsCache != null || this.dictionariesCache != null) {
            Set<String> keys = dictionary.getKeys(this.usablePrefix());
            if (this.recordsCache != null) {
                this.destroyKeys(this.recordsCache.keySet().iterator(), keys);
            }
            if (this.dictionariesCache != null) {
                this.destroyKeys(this.dictionariesCache.keySet().iterator(), keys);
            }
        }
    }

    private void clearLocaleCaches() {
        if (this.allLocales != null) {
            this.allLocales.clear();
            this.allLocales = null;
        }
        if (this.supportedLocales != null) {
            this.supportedLocales.clear();
            this.supportedLocales = null;
        }
    }

    private void destroyKeys(Iterator<String> cachedKeys, Set<String> keys) {
        block0: while (cachedKeys.hasNext()) {
            String cachedKey = cachedKeys.next();
            for (String key : keys) {
                if (!cachedKey.startsWith(key)) continue;
                cachedKeys.remove();
                continue block0;
            }
        }
    }

    public synchronized void clearDictionaries() {
        if (this.dictionaries != null) {
            this.dictionaries.clear();
            this.dictionaries = null;
            this.destroyDictionaryCaches();
        }
    }

    private void destroyDictionaryCaches() {
        if (this.dictionariesCache != null) {
            this.dictionariesCache.clear();
            this.dictionariesCache = null;
        }
    }

    public synchronized List<TranslationInformation> getTranslations() {
        return this.translations != null ? new ImmutableList<TranslationInformation>((Collection<TranslationInformation>)this.translations) : new ImmutableList<TranslationInformation>(new TranslationInformation[0]);
    }

    public synchronized void setTranslations(List<TranslationInformation> translations) {
        this.translations = translations;
    }

    public synchronized TranslationInformation getTranslation(Locale locale) {
        ArrayList<TranslationInformation> translations = new ArrayList<TranslationInformation>(1 + this.dictionariesCount());
        this.collectLanguages(locale, translations);
        if (CollectionUtils.isEmpty(translations)) {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            this.collectLocales(locales);
            for (Locale lc : locales) {
                translations.add(new TranslationInformation(lc, lc.getDisplayLanguage(), "WebLaF"));
            }
        }
        TranslationInformation info = translations.size() > 1 ? Collections.max(translations, new TranslationInformationComparator(locale)) : (translations.size() == 1 ? (TranslationInformation)translations.get(0) : null);
        return info;
    }

    private void collectLanguages(Locale locale, List<TranslationInformation> translations) {
        if (CollectionUtils.notEmpty(this.translations)) {
            for (TranslationInformation language : this.translations) {
                if (!language.getLocale().getLanguage().equals(locale.getLanguage())) continue;
                translations.add(language);
            }
        }
        if (CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary subdictionary : this.dictionaries) {
                subdictionary.collectLanguages(locale, translations);
            }
        }
    }

    private void collectLocales(List<Locale> locales) {
        if (CollectionUtils.notEmpty(this.records)) {
            for (Record record : this.records) {
                for (Value value : record.getValues()) {
                    locales.add(value.getLocale());
                }
                if (!CollectionUtils.notEmpty(locales)) continue;
                break;
            }
        }
        if (CollectionUtils.isEmpty(locales) && CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary subdictionary : this.dictionaries) {
                subdictionary.collectLocales(locales);
                if (!CollectionUtils.notEmpty(locales)) continue;
                break;
            }
        }
    }

    public synchronized void addTranslation(TranslationInformation translation) {
        if (this.translations == null) {
            this.translations = new ArrayList<TranslationInformation>(1);
        }
        this.translations.add(translation);
    }

    public synchronized List<Locale> getAllLocales() {
        if (this.allLocales == null) {
            this.allLocales = new ArrayList<Locale>();
            this.collectAllLocales(this.allLocales);
        }
        return new ImmutableList<Locale>((Collection<Locale>)this.allLocales);
    }

    private void collectAllLocales(List<Locale> locales) {
        if (CollectionUtils.notEmpty(this.records)) {
            for (Record record : this.records) {
                record.collectAllLocales(locales);
            }
        }
        if (CollectionUtils.notEmpty(this.dictionaries)) {
            for (Dictionary dictionary : this.dictionaries) {
                dictionary.collectAllLocales(locales);
            }
        }
    }

    public synchronized List<Locale> getSupportedLocales() {
        if (this.supportedLocales == null) {
            this.supportedLocales = new ArrayList<Locale>(this.getAllLocales());
            HashSet supportedCodes = null;
            HashSet<String> keyCodes = new HashSet<String>(this.supportedLocales.size());
            for (String key : this.getKeys()) {
                ArrayList<Locale> keyLocales = new ArrayList<Locale>(3);
                for (Record keyRecord : this.getRecords(key)) {
                    keyRecord.collectAllLocales(keyLocales);
                }
                for (Locale keyLocale : keyLocales) {
                    String code = keyLocale.getLanguage();
                    if (keyCodes.contains(code)) continue;
                    keyCodes.add(code);
                }
                if (supportedCodes != null) {
                    Iterator codesIterator = supportedCodes.iterator();
                    while (codesIterator.hasNext()) {
                        String code = (String)codesIterator.next();
                        if (keyCodes.contains(code)) continue;
                        codesIterator.remove();
                    }
                } else {
                    supportedCodes = new HashSet(keyCodes);
                }
                keyCodes.clear();
            }
            Iterator<Locale> localesIterator = this.supportedLocales.iterator();
            while (localesIterator.hasNext()) {
                Locale locale = localesIterator.next();
                if (supportedCodes.contains(locale.getLanguage())) continue;
                localesIterator.remove();
            }
        }
        return new ImmutableList<Locale>((Collection<Locale>)this.supportedLocales);
    }

    private String usablePrefix() {
        return TextUtils.notEmpty(this.prefix) ? this.prefix + "." : "";
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Dictionary && ((Dictionary)obj).getId().equals(this.getId());
    }

    public String toString() {
        return (this.name != null ? this.name + " " : "") + (this.getPrefix() != null ? " [" + this.getPrefix() + "]" : "") + (this.recordsCount() > 0 ? " [R:" + this.recordsCount() + "]" : "") + (this.dictionariesCount() > 0 ? " [D:" + this.dictionariesCount() + "]" : "");
    }
}

