/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.api.jdk.Objects;
import com.alee.managers.language.data.Value;
import com.alee.managers.language.data.ValueCountryComparator;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@XStreamAlias(value="record")
public final class Record
implements Cloneable,
Serializable {
    @XStreamAsAttribute
    private String key;
    @XStreamImplicit
    private List<Value> values;
    private transient Map<String, Value> valuesCache;

    public Record() {
        this(null);
    }

    public Record(String key) {
        this(key, new ArrayList<Value>(0));
    }

    public Record(String key, Value ... values) {
        this(key, CollectionUtils.asList(values));
    }

    public Record(String key, List<Value> values) {
        this.setKey(key);
        this.setValues(CollectionUtils.copy(values));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public void setValues(List<Value> values) {
        this.values = values;
    }

    public Value addValue(Value value) {
        if (this.values == null) {
            this.values = new ArrayList<Value>(1);
        }
        this.values.add(value);
        return value;
    }

    public void removeValue(Value value) {
        if (this.values != null) {
            this.values.remove(value);
        }
    }

    public void clearValues() {
        if (CollectionUtils.notEmpty(this.values)) {
            this.values.clear();
        }
    }

    public int valuesCount() {
        return this.values != null ? this.values.size() : 0;
    }

    protected void collectAllLocales(List<Locale> locales) {
        if (CollectionUtils.notEmpty(this.values)) {
            for (Value value : this.values) {
                Locale locale = value.getLocale();
                if (locales.contains(locale)) continue;
                locales.add(locale);
            }
        }
    }

    public boolean hasValue(Locale locale) {
        return this.getValue(locale) != null;
    }

    public Value getValue(Locale locale) {
        Value result;
        String key = locale.getLanguage() + "_" + locale.getCountry();
        if (this.valuesCache != null && this.valuesCache.containsKey(key)) {
            result = this.valuesCache.get(key);
        } else {
            if (CollectionUtils.notEmpty(this.values)) {
                List<Value> values = this.getValues(locale);
                ValueCountryComparator comparator = new ValueCountryComparator(locale);
                result = CollectionUtils.max(values, comparator);
            } else {
                result = null;
            }
            if (this.valuesCache == null) {
                this.valuesCache = new HashMap<String, Value>(this.values.size());
            }
            this.valuesCache.put(key, result);
        }
        return result;
    }

    public List<Value> getValues(Locale locale) {
        ArrayList<Value> values = new ArrayList<Value>(3);
        for (Value value : this.values) {
            if (!Objects.equals((Object)value.getLocale().getLanguage(), (Object)locale.getLanguage())) continue;
            values.add(value);
        }
        return values;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean boldKey) {
        return (boldKey ? "{" : "") + this.key + (boldKey ? ":b}" : "") + (this.values != null ? "[ " + TextUtils.listToString(this.values, "; ") + " ]" : "null");
    }
}

