/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.api.jdk.Supplier;
import com.alee.managers.language.data.TextConverter;
import com.alee.utils.ArrayUtils;
import com.alee.utils.HtmlUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;

@XStreamAlias(value="text")
@XStreamConverter(value=TextConverter.class)
public final class Text
implements Cloneable,
Serializable {
    @XStreamAsAttribute
    private String state;
    @XStreamAsAttribute
    private int mnemonic;
    private String text;

    public Text() {
        this("");
    }

    public Text(String text) {
        this(text, null);
    }

    public Text(String text, String state) {
        this(text, state, -1);
    }

    public Text(String text, String state, int mnemonic) {
        this.text = text;
        this.state = state;
        this.mnemonic = mnemonic;
    }

    public String getText(Object ... data) {
        String result;
        if (ArrayUtils.notEmpty(data)) {
            Object[] objects = this.parseData(data);
            result = String.format(this.text, objects);
        } else {
            result = this.text;
        }
        return result;
    }

    private Object[] parseData(Object ... data) {
        if (data != null) {
            Object[] finalData = new Object[data.length];
            for (int i = 0; i < data.length; ++i) {
                Object object = data[i];
                if (object != null) {
                    if (object instanceof Supplier) {
                        finalData[i] = ((Supplier)object).get();
                        continue;
                    }
                    finalData[i] = object;
                    continue;
                }
                finalData[i] = object;
            }
            return finalData;
        }
        return null;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
    }

    public String toString() {
        return TextUtils.shortenText(HtmlUtils.getPlainText(this.text), 50, true);
    }
}

