/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.Text;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public final class TextConverter
implements Converter {
    private static final String STATE = "state";
    private static final String MNEMONIC = "mnemonic";

    public boolean canConvert(Class type) {
        return Text.class.getCanonicalName().equals(type.getCanonicalName());
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Text value = (Text)source;
        if (value.getState() != null) {
            writer.addAttribute(STATE, "" + value.getState());
        }
        if (value.getMnemonic() != -1) {
            writer.addAttribute(MNEMONIC, Character.toString((char)value.getMnemonic()));
        }
        writer.setValue(value.getText(new Object[0]));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String state = reader.getAttribute(STATE);
        String m = reader.getAttribute(MNEMONIC);
        int mnemonic = TextUtils.notEmpty(m) ? (int)m.charAt(0) : -1;
        String value = reader.getValue();
        return new Text(value, state, mnemonic);
    }
}

