/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.api.jdk.Objects;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.ValueConverter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@XStreamAlias(value="value")
@XStreamConverter(value=ValueConverter.class)
public final class Value
implements Cloneable,
Serializable {
    @XStreamAsAttribute
    @XStreamAlias(value="lang")
    private Locale locale;
    @XStreamImplicit
    private List<Text> texts;

    public Value() {
        this(Locale.getDefault());
    }

    public Value(Locale locale) {
        this(locale, new ArrayList<Text>(0));
    }

    public Value(Locale locale, Text ... texts) {
        this(locale, CollectionUtils.asList(texts));
    }

    public Value(Locale locale, List<Text> texts) {
        this.locale = locale;
        this.texts = texts;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<Text> getTexts() {
        return this.texts;
    }

    public void setTexts(List<Text> texts) {
        this.texts = texts;
    }

    public Text addText(Text text) {
        if (this.texts == null) {
            this.texts = new ArrayList<Text>(1);
        }
        this.texts.add(text);
        return text;
    }

    public void removeText(Text text) {
        if (this.texts != null) {
            this.texts.remove(text);
        }
    }

    public void clearTexts() {
        if (CollectionUtils.notEmpty(this.texts)) {
            this.texts.clear();
        }
    }

    public int textsCount() {
        return this.texts != null ? this.texts.size() : 0;
    }

    public Text getText() {
        return this.getText(null);
    }

    public Text getText(String state) {
        Text result = null;
        if (this.texts != null) {
            for (Text text : this.texts) {
                if (!Objects.equals((Object)text.getState(), (Object)state)) continue;
                result = text;
                break;
            }
        }
        return result;
    }

    public String toString() {
        return LanguageUtils.toString(this.getLocale()) + " -> " + this.toString(this.texts);
    }

    private String toString(List<Text> texts) {
        if (texts == null || texts.size() == 0) {
            return "";
        }
        if (texts.size() == 1) {
            return texts.get(0).toString();
        }
        return "{" + TextUtils.listToString(texts, ";") + "}";
    }
}

