/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.managers.settings.SettingsGroup;
import com.alee.utils.xml.XMLChar;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class SettingsConverter
extends ReflectionConverter {
    private static final String NULL_TYPE = "null";

    public SettingsConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return type.equals(SettingsGroup.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SettingsGroup settingsGroup = (SettingsGroup)source;
        writer.addAttribute("id", settingsGroup.getId());
        writer.addAttribute("name", settingsGroup.getName());
        for (Map.Entry<String, Object> entry : settingsGroup.settings().entrySet()) {
            String nodeName;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (XMLChar.isValidName(key)) {
                nodeName = key;
                writer.startNode(nodeName);
            } else {
                nodeName = "entry";
                writer.startNode(nodeName);
                writer.addAttribute("key", key);
            }
            if (value == null) {
                writer.addAttribute("type", NULL_TYPE);
            } else {
                String serializedType = this.mapper.serializedClass(value.getClass());
                if (!nodeName.equals(serializedType)) {
                    writer.addAttribute("type", serializedType);
                }
                context.convertAnother(value);
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        SettingsGroup settingsGroup = new SettingsGroup(reader.getAttribute("id"), reader.getAttribute("name"));
        HashMap<String, Object> settings = new HashMap<String, Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals("entry") && reader.getAttributeCount() == 0) {
                reader.moveDown();
                String key = reader.getValue();
                reader.moveUp();
                reader.moveDown();
                Class type = this.mapper.realClass(reader.getNodeName());
                Object value = context.convertAnother(settings, type);
                settings.put(key, value);
                reader.moveUp();
            } else {
                String keyAttribute = reader.getAttribute("key");
                String key = keyAttribute != null ? keyAttribute : nodeName;
                try {
                    String actualType;
                    String typeAttribute = reader.getAttribute("type");
                    String string = actualType = typeAttribute != null ? typeAttribute : nodeName;
                    if (actualType.equals(NULL_TYPE)) {
                        settings.put(key, null);
                    } else {
                        Class type = this.mapper.realClass(actualType);
                        settings.put(key, context.convertAnother(settings, type));
                    }
                }
                catch (Exception e) {
                    String msg = "Unable to load settings entry for group '%s' under key '%s' due to unexpected exception";
                    String fmsg = String.format("Unable to load settings entry for group '%s' under key '%s' due to unexpected exception", settingsGroup.getName(), key);
                    LoggerFactory.getLogger(SettingsConverter.class).error(fmsg, (Throwable)e);
                }
            }
            reader.moveUp();
        }
        settingsGroup.setSettings(settings);
        return settingsGroup;
    }
}

