/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.api.jdk.Supplier;
import com.alee.managers.settings.ReadState;
import com.alee.managers.settings.SettingsException;
import com.alee.managers.settings.SettingsGroup;
import com.alee.managers.settings.SettingsGroupState;
import com.alee.managers.settings.SettingsListener;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public final class SettingsManager {
    private static final List<SettingsListener> globalSettingsListeners = new ArrayList<SettingsListener>(2);
    private static final Map<String, Map<String, List<SettingsListener>>> specificSettingsListeners = new HashMap<String, Map<String, List<SettingsListener>>>(20);
    private static String settingsFilesExtension = ".xml";
    private static String backupFilesExtension = ".backup";
    private static String defaultSettingsDir = null;
    private static String defaultSettingsDirName = ".weblaf";
    private static String defaultSettingsGroup = "default";
    private static final Map<String, String> groupFileLocation = new HashMap<String, String>();
    private static final Map<String, SettingsGroupState> groupState = new HashMap<String, SettingsGroupState>();
    private static final Map<String, SettingsGroup> groups = new HashMap<String, SettingsGroup>();
    private static final Map<String, Object> files = new HashMap<String, Object>();
    private static boolean saveOnChange = true;
    private static boolean saveDefaultValues = true;
    private static final Object saveOnChangeLock = new Object();
    private static long saveOnChangeDelay = 500L;
    private static WebTimer groupSaveScheduler = null;
    private static final List<String> groupsToSaveOnChange = new ArrayList<String>();
    private static boolean saveLoggingEnabled = false;
    private static boolean allowSave = true;
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize() {
        if (initialized) return;
        Class<SettingsManager> clazz = SettingsManager.class;
        synchronized (SettingsManager.class) {
            if (initialized) return;
            XmlUtils.processAnnotations(SettingsGroup.class);
            XmlUtils.processAnnotations(SettingsGroupState.class);
            XmlUtils.processAnnotations(ReadState.class);
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static List<SettingsGroup> getLoadedGroups() {
        return CollectionUtils.copy(groups.values());
    }

    public static Map<String, SettingsGroup> getLoadedGroupsMap() {
        return groups;
    }

    public static <T> T get(String key) {
        return SettingsManager.get(SettingsManager.getDefaultSettingsGroup(), key, null);
    }

    public static <T> T get(String key, T defaultValue) {
        return SettingsManager.get(SettingsManager.getDefaultSettingsGroup(), key, defaultValue != null ? new StaticDefaultValue<T>(defaultValue) : null);
    }

    public static <T> T get(String key, Supplier<T> defaultValueSupplier) {
        return SettingsManager.get(SettingsManager.getDefaultSettingsGroup(), key, defaultValueSupplier);
    }

    public static <T> T get(String group, String key, T defaultValue) {
        return SettingsManager.get(group, key, defaultValue != null ? new StaticDefaultValue<T>(defaultValue) : null);
    }

    public static <T> T get(String group, String key, Supplier<T> defaultValueSupplier) {
        Object value;
        SettingsManager.initialize();
        try {
            value = SettingsManager.getSettingsGroup(group).get(key);
        }
        catch (ClassCastException e) {
            String msg = "Unable to load settings value for group '%s' and key '%s' because it has inappropriate class type";
            LoggerFactory.getLogger(SettingsManager.class).warn(String.format("Unable to load settings value for group '%s' and key '%s' because it has inappropriate class type", group, key));
            value = null;
        }
        if (value == null && defaultValueSupplier != null) {
            value = defaultValueSupplier.get();
            if (saveDefaultValues) {
                SettingsManager.set(group, key, value);
            }
        }
        return value;
    }

    public static <T> T set(String key, T object) {
        return SettingsManager.set(SettingsManager.getDefaultSettingsGroup(), key, object);
    }

    public static <T> T set(String group, String key, T object) {
        SettingsManager.initialize();
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(group);
        T oldValue = settingsGroup.put(key, object);
        if (saveOnChange) {
            SettingsManager.delayedSaveSettingsGroup(group);
        }
        SettingsManager.fireSettingsChanged(group, key, oldValue, object);
        return oldValue;
    }

    public static void resetDefaultGroup() {
        SettingsManager.resetGroup(SettingsManager.getDefaultSettingsGroup());
    }

    public static void resetGroup(String group) {
        File dir = new File(SettingsManager.getGroupFilePath(group));
        if (dir.exists() && dir.isDirectory()) {
            File file = SettingsManager.getGroupFile(group, dir);
            File backupFile = SettingsManager.getGroupBackupFile(group, dir);
            FileUtils.deleteFiles(file, backupFile);
        }
        if (groups.containsKey(group)) {
            groups.remove(group);
        }
    }

    public static <T> T resetValue(String key) {
        return SettingsManager.resetValue(SettingsManager.getDefaultSettingsGroup(), key);
    }

    public static <T> T resetValue(String group, String key) {
        T oldValue = null;
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(group);
        if (settingsGroup != null) {
            oldValue = settingsGroup.remove(key);
        }
        if (oldValue != null) {
            SettingsManager.saveSettingsGroup(group);
        }
        return oldValue;
    }

    public static SettingsGroup getSettingsGroup(String group) {
        if (groups.containsKey(group)) {
            return groups.get(group);
        }
        return SettingsManager.loadSettingsGroup(group);
    }

    private static SettingsGroup loadSettingsGroup(String group) {
        SettingsGroup settingsGroup = null;
        File dir = new File(SettingsManager.getGroupFilePath(group));
        if (dir.exists() && dir.isDirectory()) {
            File file = SettingsManager.getGroupFile(group, dir);
            File backupFile = SettingsManager.getGroupBackupFile(group, dir);
            if (file.exists() && file.isFile() || backupFile.exists() && backupFile.isFile()) {
                boolean readFromBackup = false;
                if (backupFile.exists() && backupFile.isFile()) {
                    FileUtils.copyFile(backupFile, file);
                    FileUtils.deleteFile(backupFile);
                    readFromBackup = true;
                }
                if (file.exists() && file.isFile()) {
                    try {
                        settingsGroup = (SettingsGroup)XmlUtils.fromXML(file);
                        groupState.put(group, new SettingsGroupState(readFromBackup ? ReadState.restored : ReadState.ok));
                        String state = readFromBackup ? "restored from backup" : "loaded";
                        String msg = "Settings group '%s' %s successfully";
                        LoggerFactory.getLogger(SettingsManager.class).info(String.format("Settings group '%s' %s successfully", group, state));
                    }
                    catch (Exception e) {
                        String msg = "Unable to load settings group '%s' due to unexpected exception";
                        LoggerFactory.getLogger(SettingsManager.class).error(String.format("Unable to load settings group '%s' due to unexpected exception", group), (Throwable)e);
                        FileUtils.deleteFile(file);
                        groupState.put(group, new SettingsGroupState(ReadState.failed, e));
                    }
                }
            } else {
                groupState.put(group, new SettingsGroupState(ReadState.created));
                String msg = "Settings group '%s' created successfully";
                LoggerFactory.getLogger(SettingsManager.class).info(String.format("Settings group '%s' created successfully", group));
            }
        } else {
            groupState.put(group, new SettingsGroupState(ReadState.created));
            String msg = "Settings group '%s' created successfully";
            LoggerFactory.getLogger(SettingsManager.class).info(String.format("Settings group '%s' created successfully", group));
        }
        if (settingsGroup == null) {
            settingsGroup = new SettingsGroup(group);
        }
        groups.put(group, settingsGroup);
        return settingsGroup;
    }

    public static void saveSettings() {
        for (Map.Entry<String, SettingsGroup> entry : groups.entrySet()) {
            SettingsManager.saveSettingsGroup(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : files.entrySet()) {
            SettingsManager.saveSettings(entry.getKey(), entry.getValue());
        }
    }

    public static void saveSettingsGroup(String group) {
        SettingsManager.saveSettingsGroup(SettingsManager.getSettingsGroup(group));
    }

    public static void saveSettingsGroup(SettingsGroup settingsGroup) {
        block7: {
            if (allowSave) {
                try {
                    String group = settingsGroup.getName();
                    File dir = new File(SettingsManager.getGroupFilePath(group));
                    if (FileUtils.ensureDirectoryExists(dir)) {
                        File file = SettingsManager.getGroupFile(group, dir);
                        File backupFile = null;
                        if (file.exists()) {
                            backupFile = SettingsManager.getGroupBackupFile(group, dir);
                            FileUtils.copyFile(file, backupFile);
                        }
                        XmlUtils.toXML((Object)settingsGroup, file);
                        if (backupFile != null && backupFile.exists()) {
                            FileUtils.deleteFile(backupFile);
                        }
                        if (saveLoggingEnabled) {
                            String msg = "Settings group '%s' saved successfully";
                            LoggerFactory.getLogger(SettingsManager.class).info(String.format("Settings group '%s' saved successfully", group));
                        }
                        break block7;
                    }
                    String msg = "Cannot create settings directory: %s";
                    throw new SettingsException(String.format("Cannot create settings directory: %s", dir.getAbsolutePath()));
                }
                catch (Exception e) {
                    String msg = "Unable to save settings group '%s' due to unexpected exception";
                    LoggerFactory.getLogger(SettingsManager.class).error(String.format("Unable to save settings group '%s' due to unexpected exception", settingsGroup.getName()), (Throwable)e);
                }
            }
        }
    }

    private static File getGroupFile(String group, File dir) {
        return new File(dir, group + settingsFilesExtension);
    }

    private static File getGroupBackupFile(String group, File dir) {
        return new File(dir, group + settingsFilesExtension + backupFilesExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delayedSaveSettingsGroup(String group) {
        if (saveOnChangeDelay > 0L) {
            Object object = saveOnChangeLock;
            synchronized (object) {
                if (!groupsToSaveOnChange.contains(group)) {
                    groupsToSaveOnChange.add(group);
                }
                if (groupSaveScheduler == null || !groupSaveScheduler.isRunning()) {
                    if (groupSaveScheduler == null) {
                        groupSaveScheduler = new WebTimer("SettingsManager.groupSaveScheduler", saveOnChangeDelay, new ActionListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Object object = saveOnChangeLock;
                                synchronized (object) {
                                    for (String group : groupsToSaveOnChange) {
                                        SettingsManager.saveSettingsGroup(group);
                                    }
                                    groupsToSaveOnChange.clear();
                                }
                            }
                        });
                        groupSaveScheduler.setRepeats(false);
                    } else {
                        groupSaveScheduler.setDelay(saveOnChangeDelay);
                    }
                    groupSaveScheduler.start();
                }
            }
        } else {
            SettingsManager.saveSettingsGroup(group);
        }
    }

    public SettingsGroupState getSettingsGroupState(String group) {
        if (!groupState.containsKey(group)) {
            groupState.put(group, new SettingsGroupState(ReadState.none));
        }
        return groupState.get(group);
    }

    public static Object getSettings(String fileName) {
        return SettingsManager.getSettings(fileName, null);
    }

    public static <T> T getSettings(String fileName, final T defaultValue) {
        return SettingsManager.getSettings(fileName, new Supplier<T>(){

            @Override
            public T get() {
                return defaultValue;
            }
        });
    }

    public static <T> T getSettings(String fileName, Supplier<T> defaultValue) {
        Object value;
        if (files.containsKey(fileName)) {
            return (T)files.get(fileName);
        }
        try {
            File settingsFile = SettingsManager.getSettingsFile(fileName);
            value = settingsFile.exists() ? XmlUtils.fromXML(settingsFile) : (defaultValue != null ? defaultValue.get() : null);
        }
        catch (Exception e) {
            String msg = "Unable to load settings file '%s' due to unexpected exception";
            LoggerFactory.getLogger(SettingsManager.class).error(String.format("Unable to load settings file '%s' due to unexpected exception", fileName), (Throwable)e);
            value = defaultValue != null ? defaultValue.get() : null;
        }
        files.put(fileName, value);
        return value;
    }

    public static void setSettings(String fileName, Object settings) {
        files.put(fileName, settings);
        if (saveOnChange) {
            SettingsManager.saveSettings(fileName, settings);
        }
    }

    private static void saveSettings(String fileName, Object settings) {
        if (allowSave) {
            File settingsFile = SettingsManager.getSettingsFile(fileName);
            File dir = FileUtils.getParent(settingsFile);
            if (FileUtils.ensureDirectoryExists(dir)) {
                XmlUtils.toXML(settings, settingsFile);
            } else {
                String msg = "Cannot create settings directory: %s";
                throw new SettingsException(String.format("Cannot create settings directory: %s", dir.getAbsolutePath()));
            }
        }
    }

    public static boolean settingsExists(String fileName) {
        return SettingsManager.getSettingsFile(fileName).exists();
    }

    private static File getSettingsFile(String fileName) {
        return new File(SettingsManager.getDefaultSettingsDir(), fileName);
    }

    public static String getSettingsFilesExtension() {
        return settingsFilesExtension;
    }

    public static void setSettingsFilesExtension(String settingsFilesExtension) {
        SettingsManager.settingsFilesExtension = settingsFilesExtension;
    }

    public static String getBackupFilesExtension() {
        return backupFilesExtension;
    }

    public static void setBackupFilesExtension(String backupFilesExtension) {
        SettingsManager.backupFilesExtension = backupFilesExtension;
    }

    public static String getDefaultSettingsDir() {
        if (defaultSettingsDir == null) {
            return FileUtils.getUserHomePath() + defaultSettingsDirName;
        }
        return defaultSettingsDir;
    }

    public static void setDefaultSettingsDir(String defaultSettingsDir) {
        SettingsManager.defaultSettingsDir = defaultSettingsDir;
    }

    public static String getDefaultSettingsDirName() {
        return defaultSettingsDirName;
    }

    public static void setDefaultSettingsDirName(String defaultSettingsDir) {
        defaultSettingsDirName = defaultSettingsDir;
    }

    public static String getDefaultSettingsGroup() {
        return defaultSettingsGroup;
    }

    public static void setDefaultSettingsGroup(String defaultSettingsGroup) {
        SettingsManager.defaultSettingsGroup = defaultSettingsGroup;
    }

    public static void setGroupFilePath(String group, String dir) {
        groupFileLocation.put(group, dir);
    }

    public static String getGroupFilePath(String group) {
        if (groupFileLocation.containsKey(group)) {
            return groupFileLocation.get(group);
        }
        return SettingsManager.getDefaultSettingsDir();
    }

    public static boolean isSaveOnChange() {
        return saveOnChange;
    }

    public static void setSaveOnChange(boolean saveOnChange) {
        SettingsManager.saveOnChange = saveOnChange;
    }

    public static boolean isSaveDefaultValues() {
        return saveDefaultValues;
    }

    public static void setSaveDefaultValues(boolean saveDefaultValues) {
        SettingsManager.saveDefaultValues = saveDefaultValues;
    }

    public static long getSaveOnChangeDelay() {
        return saveOnChangeDelay;
    }

    public static void setSaveOnChangeDelay(long saveOnChangeDelay) {
        SettingsManager.saveOnChangeDelay = saveOnChangeDelay;
    }

    public static boolean isSaveLoggingEnabled() {
        return saveLoggingEnabled;
    }

    public static void setSaveLoggingEnabled(boolean enabled) {
        saveLoggingEnabled = enabled;
    }

    public static boolean isAllowSave() {
        return allowSave;
    }

    public static void setAllowSave(boolean allowSave) {
        SettingsManager.allowSave = allowSave;
    }

    public static void disableSave() {
        SettingsManager.setAllowSave(false);
    }

    public static void enableSave() {
        SettingsManager.setAllowSave(true);
    }

    public static void addSettingsListener(SettingsListener listener) {
        globalSettingsListeners.add(listener);
    }

    public static void addSettingsListener(String key, SettingsListener listener) {
        SettingsManager.addSettingsListener(SettingsManager.getDefaultSettingsGroup(), key, listener);
    }

    public static void addSettingsListener(String group, String key, SettingsListener listener) {
        if (!specificSettingsListeners.containsKey(group)) {
            specificSettingsListeners.put(group, new HashMap());
        }
        if (!specificSettingsListeners.get(group).containsKey(key)) {
            specificSettingsListeners.get(group).put(key, new ArrayList());
        }
        specificSettingsListeners.get(group).get(key).add(listener);
    }

    public static void removeSettingsListener(SettingsListener listener) {
        globalSettingsListeners.remove(listener);
    }

    public static void removeSettingsListener(String key, SettingsListener listener) {
        SettingsManager.removeSettingsListener(SettingsManager.getDefaultSettingsGroup(), key, listener);
    }

    public static void removeSettingsListener(String group, String key, SettingsListener listener) {
        if (specificSettingsListeners.containsKey(group) && specificSettingsListeners.get(group).containsKey(key)) {
            specificSettingsListeners.get(group).get(key).remove(listener);
        }
    }

    private static void fireSettingsChanged(String group, String key, Object oldValue, Object newValue) {
        for (SettingsListener listener : CollectionUtils.copy(globalSettingsListeners)) {
            listener.settingsChanged(group, key, oldValue, newValue);
        }
        if (specificSettingsListeners.containsKey(group) && specificSettingsListeners.get(group).containsKey(key)) {
            for (SettingsListener listener : CollectionUtils.copy((Collection)specificSettingsListeners.get(group).get(key))) {
                listener.settingsChanged(group, key, oldValue, newValue);
            }
        }
    }

    private static class StaticDefaultValue<V>
    implements Supplier<V> {
        private final V value;

        public StaticDefaultValue(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }
    }
}

