/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.UtilityException;
import java.lang.reflect.Array;

public final class ArrayUtils {
    private ArrayUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static <T> boolean isEmpty(T ... data) {
        return data == null || data.length == 0;
    }

    public static <T> boolean notEmpty(T ... data) {
        return data != null && data.length > 0;
    }

    public static boolean contains(int number, int[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(long number, long[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(float number, float[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(double number, double[] array) {
        return ArrayUtils.indexOf(number, array) != -1;
    }

    public static boolean contains(char character, char[] array) {
        return ArrayUtils.indexOf(character, array) != -1;
    }

    public static boolean contains(byte data, byte[] array) {
        return ArrayUtils.indexOf(data, array) != -1;
    }

    public static boolean contains(String text, String[] array) {
        return ArrayUtils.indexOf(text, array) != -1;
    }

    public static boolean contains(Object object, Object[] array) {
        return ArrayUtils.indexOf(object, array) != -1;
    }

    public static int indexOf(int number, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long number, long[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float number, float[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double number, double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char character, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != character) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte data, byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != data) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String text, String[] array) {
        return ArrayUtils.indexOf(text, array, false);
    }

    public static int indexOf(String text, String[] array, boolean ignoreCase) {
        for (int i = 0; i < array.length; ++i) {
            String txt = array[i];
            if ((txt != null || text != null) && (txt == null || text == null || !(ignoreCase ? txt.equalsIgnoreCase(text) : txt.equals(text)))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object object, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if ((obj != null || object != null) && (obj == null || object == null || !obj.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Object object, Object[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            Object obj = array[i];
            if ((obj != null || object != null) && (obj == null || object == null || !obj.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] remove(T[] array, T object) {
        T[] newArray = ArrayUtils.createArray(array, array.length - 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (mod == 0 && array[i] == object) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static int[] remove(int[] array, int index) {
        int[] newArray = new int[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static float[] remove(float[] array, int index) {
        float[] newArray = new float[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static double[] remove(double[] array, int index) {
        double[] newArray = new double[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static char[] remove(char[] array, int index) {
        char[] newArray = new char[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static byte[] remove(byte[] array, int index) {
        byte[] newArray = new byte[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static boolean[] remove(boolean[] array, int index) {
        boolean[] newArray = new boolean[array.length - 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static <T> T[] remove(T[] array, int index) {
        T[] newArray = ArrayUtils.createArray(array, array.length - 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                mod = -1;
                continue;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static int[] insert(int[] array, int index, int object) {
        int[] newArray = new int[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static float[] insert(float[] array, int index, float object) {
        float[] newArray = new float[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static double[] insert(double[] array, int index, double object) {
        double[] newArray = new double[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static char[] insert(char[] array, int index, char object) {
        char[] newArray = new char[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static byte[] insert(byte[] array, int index, byte object) {
        byte[] newArray = new byte[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static boolean[] insert(boolean[] array, int index, boolean object) {
        boolean[] newArray = new boolean[array.length + 1];
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static <T> T[] insert(T[] array, int index, T object) {
        T[] newArray = ArrayUtils.createArray(array, array.length + 1);
        int mod = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) {
                newArray[i] = object;
                mod = 1;
            }
            newArray[i + mod] = array[i];
        }
        return newArray;
    }

    public static <T> T[] createArray(T[] array, int length) {
        return ArrayUtils.createArray(array.getClass().getComponentType(), length);
    }

    public static <T> T[] createArray(Class<T> classType, int length) {
        return (Object[])Array.newInstance(classType, length);
    }

    public static boolean equals(int[] array1, int[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int number : array1) {
            if (ArrayUtils.contains(number, array2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] array1, long[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (long number : array1) {
            if (ArrayUtils.contains(number, array2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] array1, float[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (float number : array1) {
            if (ArrayUtils.contains(number, array2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] array1, double[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (double number : array1) {
            if (ArrayUtils.contains(number, array2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] array1, char[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (char character : array1) {
            if (ArrayUtils.contains(character, array2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] array1, byte[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (byte data : array1) {
            if (ArrayUtils.contains(data, array2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String[] array1, String[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (String text : array1) {
            if (ArrayUtils.contains(text, array2)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] array1, T[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        for (T object : array1) {
            if (ArrayUtils.contains(object, array2)) continue;
            return false;
        }
        return true;
    }
}

