/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.jdk.Function;
import com.alee.api.jdk.Objects;
import com.alee.api.jdk.Supplier;
import com.alee.utils.UtilityException;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean notEmpty(Collection collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> List<T> nonNull(List<T> list) {
        return list != null ? list : new ArrayList(0);
    }

    public static <T> List<T> limit(List<T> list, int limit) {
        return list.size() <= limit ? list : CollectionUtils.copySubList(list, 0, limit);
    }

    public static <T> T max(Collection<T> collection, Comparator<T> comparator) {
        T result = CollectionUtils.isEmpty(collection) ? null : (collection.size() == 1 ? (T)collection.iterator().next() : (T)Collections.max(collection, comparator));
        return result;
    }

    public static <T> ArrayList<T> copySubList(List<T> list, int fromIndex, int toIndex) {
        return new ArrayList<T>(list.subList(fromIndex, toIndex));
    }

    public static ArrayList<Boolean> asList(boolean[] data) {
        ArrayList<Boolean> list = new ArrayList<Boolean>(data.length);
        for (boolean i : data) {
            list.add(i);
        }
        return list;
    }

    public static ArrayList<Integer> asList(int[] data) {
        ArrayList<Integer> list = new ArrayList<Integer>(data.length);
        for (int i : data) {
            list.add(i);
        }
        return list;
    }

    public static ArrayList<Character> asList(char[] data) {
        ArrayList<Character> list = new ArrayList<Character>(data.length);
        for (char i : data) {
            list.add(Character.valueOf(i));
        }
        return list;
    }

    public static ArrayList<Byte> asList(byte[] data) {
        ArrayList<Byte> list = new ArrayList<Byte>(data.length);
        for (byte i : data) {
            list.add(i);
        }
        return list;
    }

    public static ArrayList<Short> asList(short[] data) {
        ArrayList<Short> list = new ArrayList<Short>(data.length);
        for (short i : data) {
            list.add(i);
        }
        return list;
    }

    public static ArrayList<Long> asList(long[] data) {
        ArrayList<Long> list = new ArrayList<Long>(data.length);
        for (long i : data) {
            list.add(i);
        }
        return list;
    }

    public static ArrayList<Float> asList(float[] data) {
        ArrayList<Float> list = new ArrayList<Float>(data.length);
        for (float i : data) {
            list.add(Float.valueOf(i));
        }
        return list;
    }

    public static ArrayList<Double> asList(double[] data) {
        ArrayList<Double> list = new ArrayList<Double>(data.length);
        for (double i : data) {
            list.add(i);
        }
        return list;
    }

    public static <T> ArrayList<T> asList(T ... data) {
        ArrayList list = new ArrayList(data.length);
        Collections.addAll(list, data);
        return list;
    }

    public static <T> ArrayList<T> asList(Iterator<T> data) {
        ArrayList<T> list = new ArrayList<T>();
        while (data.hasNext()) {
            list.add(data.next());
        }
        return list;
    }

    public static <T> ArrayList<T> asNonNullList(T ... data) {
        ArrayList<T> list = new ArrayList<T>(data.length);
        if (data != null) {
            for (T object : data) {
                if (object == null) continue;
                list.add(object);
            }
        }
        return list;
    }

    public static <T> boolean areAllUnique(Collection<T> collection) {
        return new HashSet<T>(collection).size() == collection.size();
    }

    public static boolean addUnique(Collection<Boolean> collection, boolean[] objects) {
        boolean result = false;
        for (boolean object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static boolean addUnique(Collection<Integer> collection, int[] objects) {
        boolean result = false;
        for (int object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static boolean addUnique(Collection<Character> collection, char[] objects) {
        boolean result = false;
        for (char object : objects) {
            if (collection.contains(Character.valueOf(object))) continue;
            result |= collection.add(Character.valueOf(object));
        }
        return result;
    }

    public static boolean addUnique(Collection<Byte> collection, byte[] objects) {
        boolean result = false;
        for (byte object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static boolean addUnique(Collection<Short> collection, short[] objects) {
        boolean result = false;
        for (short object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static boolean addUnique(Collection<Long> collection, long[] objects) {
        boolean result = false;
        for (long object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static boolean addUnique(Collection<Float> collection, float[] objects) {
        boolean result = false;
        for (float object : objects) {
            if (collection.contains(Float.valueOf(object))) continue;
            result |= collection.add(Float.valueOf(object));
        }
        return result;
    }

    public static boolean addUnique(Collection<Double> collection, double[] objects) {
        boolean result = false;
        for (double object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean addUnique(Collection<T> collection, T ... objects) {
        boolean result = false;
        for (T object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean addUnique(Collection<T> collection, Collection<T> objects) {
        boolean result = false;
        for (T object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean addUniqueNonNull(Collection<T> collection, T ... objects) {
        boolean result = false;
        for (T object : objects) {
            if (collection.contains(object) || object == null) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean addUniqueNonNull(Collection<T> collection, Collection<T> objects) {
        boolean result = false;
        for (T object : objects) {
            if (collection.contains(object) || object == null) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean removeAll(Collection<T> collection, T ... objects) {
        boolean result = false;
        for (T object : objects) {
            result |= collection.remove(object);
        }
        return result;
    }

    public static <T> boolean removeAll(Collection<T> collection, Collection<T> objects) {
        boolean result = false;
        for (T object : objects) {
            result |= collection.remove(object);
        }
        return result;
    }

    public static <T> ArrayList<T> join(Collection<T> ... collections) {
        int size = 0;
        if (collections != null) {
            for (Collection<T> collection : collections) {
                size += collection != null ? collection.size() : 0;
            }
        }
        ArrayList<T> list = new ArrayList<T>(size);
        if (collections != null) {
            for (Collection<T> collection : collections) {
                if (!CollectionUtils.notEmpty(collection)) continue;
                list.addAll(collection);
            }
        }
        return list;
    }

    public static <T> ArrayList<T> copy(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> removeNulls(List<T> list) {
        if (list == null) {
            return null;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
        }
        return list;
    }

    public static boolean equals(Collection collection1, Collection collection2) {
        boolean equal;
        boolean bl = equal = collection1.size() == collection2.size();
        if (equal) {
            for (Object element : collection1) {
                if (collection2.contains(element)) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public static boolean equals(List list1, List list2, boolean strictIndices) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null || list1.size() != list2.size()) {
            return false;
        }
        if (strictIndices) {
            for (int i = 0; i < list1.size(); ++i) {
                if (!Objects.notEquals(list1.get(i), list2.get(i))) continue;
                return false;
            }
        } else {
            for (Object object : list1) {
                if (list2.contains(object)) continue;
                return false;
            }
            for (Object object : list2) {
                if (list1.contains(object)) continue;
                return false;
            }
        }
        return true;
    }

    public static int[] toIntArray(Collection<Integer> collection) {
        int[] array = new int[collection.size()];
        int index = 0;
        for (Integer integer : collection) {
            array[index] = integer != null ? integer : 0;
            ++index;
        }
        return array;
    }

    public static Object[] toObjectArray(Collection collection) {
        Object[] array = new Object[collection.size()];
        int index = 0;
        for (Object object : collection) {
            array[index] = object;
            ++index;
        }
        return array;
    }

    public static <T> ArrayList<String> toStringList(List<T> list, Function<T, String> textProvider) {
        ArrayList<String> stringList = new ArrayList<String>(list.size());
        for (T element : list) {
            stringList.add(textProvider.apply(element));
        }
        return stringList;
    }

    public static <T> ArrayList<T> toList(T[] array) {
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        return list;
    }

    public static <T> ArrayList<T> toList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    public static <T> Vector<T> toVector(Collection<T> collection) {
        return new Vector<T>(collection);
    }

    public static <T> Vector<T> asVector(T ... data) {
        Vector vector = new Vector(data.length);
        Collections.addAll(vector, data);
        return vector;
    }

    public static <T> ArrayList<T> filter(Collection<T> collection, Filter<T> filter) {
        ArrayList<Object> filtered;
        if (filter != null) {
            filtered = new ArrayList(collection.size());
            for (T element : collection) {
                if (!filter.accept(element)) continue;
                filtered.add(element);
            }
        } else {
            filtered = new ArrayList<T>(collection);
        }
        return filtered;
    }

    public static <T> ArrayList<T> filter(Collection<T> collection, Filter<T> ... filters) {
        ArrayList<T> filtered = new ArrayList<T>(collection.size());
        for (T element : collection) {
            Filter<T> filter;
            for (int i = 0; i < filters.length && ((filter = filters[i]) == null || filter.accept(element)); ++i) {
                if (i != filters.length - 1) continue;
                filtered.add(element);
            }
        }
        return filtered;
    }

    public static <T> List<T> distinct(List<T> list) {
        HashSet<T> seen = new HashSet<T>(list.size());
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!seen.contains(element)) {
                seen.add(element);
                continue;
            }
            iterator.remove();
        }
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<T> comparator) {
        if (comparator != null) {
            Object[] array = list.toArray();
            Arrays.sort(array, comparator);
            ListIterator<T> iterator = list.listIterator();
            for (Object element : array) {
                iterator.next();
                iterator.set(element);
            }
        }
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<T> ... comparators) {
        for (Comparator<T> comparator : comparators) {
            if (comparator == null) continue;
            CollectionUtils.sort(list, comparator);
        }
        return list;
    }

    public static <K, V> ArrayList<K> keysList(Map<K, V> map) {
        return new ArrayList<K>(map.keySet());
    }

    public static <K, V> ArrayList<V> valuesList(Map<K, V> map) {
        return new ArrayList<V>(map.values());
    }

    public static <K, V> ArrayList<V> valuesSummaryList(Map<K, List<V>> map) {
        ArrayList<V> summary = new ArrayList<V>(0);
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            List<V> list = entry.getValue();
            summary.ensureCapacity(summary.size() + list.size());
            for (V value : list) {
                if (summary.contains(value)) continue;
                summary.add(value);
            }
        }
        return summary;
    }

    public static <T> List<T> fillList(int size, Function<Integer, T> indexMapper) {
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(indexMapper.apply(i));
        }
        return list;
    }

    public static <T> HashSet<T> asHashSet(Collection<T> data) {
        return new HashSet<T>(data);
    }

    public static <T> HashSet<T> asHashSet(T ... data) {
        HashSet set = new HashSet(data.length);
        Collections.addAll(set, data);
        return set;
    }

    public static List<Integer> intRange(int from, int to) {
        ArrayList<Integer> range = new ArrayList<Integer>(Math.max(from, to) - Math.min(from, to) + 1);
        for (int i = from; i != to; i += from < to ? 1 : -1) {
            range.add(i);
        }
        range.add(to);
        return range;
    }

    public static <T extends Collection<?>> T requireNotEmpty(T collection, Supplier<RuntimeException> exceptionSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw exceptionSupplier.get();
        }
        return collection;
    }
}

