/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;

public final class ColorUtils {
    private static final Map<Integer, Color> colors = new HashMap<Integer, Color>(50);

    private ColorUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static Color color(int red, int green, int blue) {
        return ColorUtils.color(red, green, blue, 255);
    }

    public static Color color(int red, int green, int blue, int alpha) {
        int rgb = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        Color color = colors.get(red);
        if (color == null) {
            color = new Color(red, green, blue, alpha);
            colors.put(rgb, color);
        }
        return color;
    }

    public static Color black(int alpha) {
        return ColorUtils.color(0, 0, 0, alpha);
    }

    public static Color white(int alpha) {
        return ColorUtils.color(255, 255, 255, alpha);
    }

    public static Color grayscale(Color color) {
        int avg = (int)((double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.114);
        return ColorUtils.color(avg, avg, avg, color.getAlpha());
    }

    public static Color transparent() {
        return ColorUtils.color(255, 255, 255, 0);
    }

    public static Color transparent(Color color, int alpha) {
        return ColorUtils.color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color opaque(Color color) {
        return color.getAlpha() != 255 ? ColorUtils.color(color.getRed(), color.getGreen(), color.getBlue(), 255) : color;
    }

    public static Color webSafe(Color color) {
        return ColorUtils.color(ColorUtils.webSafe(color.getRed()), ColorUtils.webSafe(color.getGreen()), ColorUtils.webSafe(color.getBlue()));
    }

    public static int webSafe(int value) {
        if (0 <= value && value <= 51) {
            return value > 51 - value ? 51 : 0;
        }
        if (51 <= value && value <= 102) {
            return 51 + value > 102 - value ? 102 : 51;
        }
        if (102 <= value && value <= 153) {
            return 102 + value > 153 - value ? 153 : 102;
        }
        if (153 <= value && value <= 204) {
            return 153 + value > 204 - value ? 204 : 153;
        }
        if (204 <= value && value <= 255) {
            return 204 + value > 255 - value ? 255 : 204;
        }
        return value;
    }

    public static Color intermediate(Color color1, Color color2, float progress) {
        if (progress <= 0.0f) {
            return color1;
        }
        if (progress >= 1.0f) {
            return color2;
        }
        return new Color(ColorUtils.intermediate(color1.getRed(), color2.getRed(), progress), ColorUtils.intermediate(color1.getGreen(), color2.getGreen(), progress), ColorUtils.intermediate(color1.getBlue(), color2.getBlue(), progress), ColorUtils.intermediate(color1.getAlpha(), color2.getAlpha(), progress));
    }

    private static int intermediate(int value1, int value2, float progress) {
        return value1 + Math.round(((float)value2 - (float)value1) * progress);
    }

    public static String toHex(Color color) {
        int rgb = color.getRGB();
        if (rgb == 0) {
            return "#000000";
        }
        String hex = Integer.toHexString(rgb).toUpperCase(Locale.ROOT);
        return "#" + hex.substring(2, hex.length());
    }

    public static Color fromHex(String hex) {
        String clean = TextUtils.removeSpacings(hex);
        return Color.decode(clean.startsWith("#") ? clean : "#" + clean);
    }

    public static String toRGB(Color color) {
        return ColorUtils.toRGB(color, ",");
    }

    public static String toRGB(Color color, String separator) {
        return color.getRed() + separator + color.getGreen() + separator + color.getBlue() + (color.getAlpha() < 255 ? separator + color.getAlpha() : "");
    }

    public static Color fromRGB(String rgb) {
        return ColorUtils.fromRGB(rgb, ",");
    }

    public static Color fromRGB(String rgb, String separator) {
        String clean = TextUtils.removeSpacings(rgb);
        StringTokenizer st = new StringTokenizer(clean, separator, false);
        int count = st.countTokens();
        if (count == 3) {
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        if (count == 4) {
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        throw new RuntimeException("Unable to parse RGB color: " + rgb);
    }

    public static Color softColor(Color base) {
        Random random = new Random();
        int red = random.nextInt(256);
        int green = random.nextInt(256);
        int blue = random.nextInt(256);
        if (base != null) {
            red = (red + base.getRed()) / 2;
            green = (green + base.getGreen()) / 2;
            blue = (blue + base.getBlue()) / 2;
        }
        return new Color(red, green, blue);
    }
}

