/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.UtilityException;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.slf4j.LoggerFactory;

public final class CoreSwingUtils {
    private CoreSwingUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static void enableEventQueueLogging() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable e) {
                    String msg = "Uncaught EventQueue exception: %s";
                    LoggerFactory.getLogger(CoreSwingUtils.class).error(String.format("Uncaught EventQueue exception: %s", e.toString()), e);
                }
            }
        });
    }

    public static Window getWindowAncestor(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            return (Window)p;
        }
        return null;
    }

    public static JRootPane getRootPane(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JFrame) {
            return ((JFrame)component).getRootPane();
        }
        if (component instanceof JDialog) {
            return ((JDialog)component).getRootPane();
        }
        if (component instanceof JWindow) {
            return ((JWindow)component).getRootPane();
        }
        if (component instanceof JApplet) {
            return ((JApplet)component).getRootPane();
        }
        if (component instanceof JRootPane) {
            return (JRootPane)component;
        }
        return CoreSwingUtils.getRootPane(component.getParent());
    }

    public static boolean isVisibleOnScreen(Component component) {
        boolean visible;
        if (component.isShowing()) {
            Rectangle bounds = CoreSwingUtils.getBoundsOnScreen(component, true);
            visible = bounds.width > 0 && bounds.height > 0;
        } else {
            visible = false;
        }
        return visible;
    }

    public static Rectangle getBoundsOnScreen(Component component, boolean visibleOnly) {
        Rectangle bounds;
        Point los = CoreSwingUtils.locationOnScreen(component);
        Dimension size = component.getSize();
        if (visibleOnly) {
            Rectangle visible;
            if (component instanceof JComponent) {
                visible = ((JComponent)component).getVisibleRect();
            } else {
                visible = new Rectangle();
                CoreSwingUtils.computeVisibleRect(component, visible);
            }
            bounds = new Rectangle(los.x + visible.x, los.y + visible.y, visible.width, visible.height);
        } else {
            bounds = new Rectangle(los, size);
        }
        return bounds;
    }

    public static Rectangle getBoundsInWindow(Component component) {
        return component instanceof Window || component instanceof JApplet ? CoreSwingUtils.getRootPane(component).getBounds() : CoreSwingUtils.getRelativeBounds(component, CoreSwingUtils.getRootPane(component));
    }

    public static Rectangle getRelativeBounds(Component component, Component relativeTo) {
        return new Rectangle(CoreSwingUtils.getRelativeLocation(component, relativeTo), component.getSize());
    }

    public static Point getRelativeLocation(Component component, Component relativeTo) {
        Point los = CoreSwingUtils.locationOnScreen(component);
        Point rt = CoreSwingUtils.locationOnScreen(relativeTo);
        return new Point(los.x - rt.x, los.y - rt.y);
    }

    public static boolean isAncestorOf(Component ancestor, Component component) {
        return ancestor instanceof Container && ((Container)ancestor).isAncestorOf(component);
    }

    public static boolean isSameAncestor(Component component1, Component component2) {
        return CoreSwingUtils.getWindowAncestor(component1) == CoreSwingUtils.getWindowAncestor(component2);
    }

    public static Insets getWindowDecorationInsets(Window window) {
        JRootPane rootPane;
        Insets insets = new Insets(0, 0, 0, 0);
        if ((window instanceof Dialog || window instanceof Frame) && (rootPane = CoreSwingUtils.getRootPane(window)) != null) {
            if (window.isShowing()) {
                if (window instanceof Dialog && !((Dialog)window).isUndecorated() || window instanceof Frame && !((Frame)window).isUndecorated()) {
                    Rectangle wlos = CoreSwingUtils.getBoundsOnScreen(window, false);
                    Rectangle rlos = CoreSwingUtils.getBoundsOnScreen(rootPane, false);
                    insets.top = rlos.y - wlos.y;
                    insets.left = rlos.x - wlos.x;
                    insets.bottom = wlos.y + wlos.height - rlos.y - rlos.height;
                    insets.right = wlos.x + wlos.width - rlos.x - rlos.width;
                } else {
                    insets.top = 25;
                }
            } else {
                insets.top = 25;
            }
        }
        return insets;
    }

    public static boolean isFullScreen(Component component) {
        GraphicsConfiguration gc;
        Window window = CoreSwingUtils.getWindowAncestor(component);
        if (window != null && (gc = window.getGraphicsConfiguration()) != null) {
            GraphicsDevice device = gc.getDevice();
            return device != null && device.getFullScreenWindow() == window;
        }
        return false;
    }

    public static PointerInfo getPointerInfo() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            GraphicsDevice device = SystemUtils.getDefaultScreenDevice();
            Point location = new Point(0, 0);
            pointerInfo = (PointerInfo)ReflectUtils.createInstanceSafely(PointerInfo.class, device, location);
        }
        return pointerInfo;
    }

    public static Point getMouseLocation() {
        return CoreSwingUtils.getPointerInfo().getLocation();
    }

    public static Point getMouseLocation(Component component) {
        Point mouse = CoreSwingUtils.getMouseLocation();
        Point los = CoreSwingUtils.locationOnScreen(component);
        return new Point(mouse.x - los.x, mouse.y - los.y);
    }

    public static boolean isHovered(Component component) {
        boolean hover = false;
        if (component.isShowing()) {
            Rectangle vr = CoreSwingUtils.computeVisibleRect(component, new Rectangle());
            if (vr.width > 0 && vr.height > 0 && CoreSwingUtils.getBoundsOnScreen(component, true).contains(CoreSwingUtils.getMouseLocation())) {
                hover = true;
            }
        }
        return hover;
    }

    private static Rectangle computeVisibleRect(Component component, Rectangle visibleRect) {
        Container p = component.getParent();
        Rectangle bounds = component.getBounds();
        if (p == null || p instanceof Window || p instanceof Applet) {
            visibleRect.setBounds(0, 0, bounds.width, bounds.height);
        } else {
            CoreSwingUtils.computeVisibleRect(p, visibleRect);
            visibleRect.x -= bounds.x;
            visibleRect.y -= bounds.y;
            SwingUtilities.computeIntersection(0, 0, bounds.width, bounds.height, visibleRect);
        }
        return visibleRect;
    }

    public static Point locationOnScreen(Component component) {
        try {
            return component.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            throw new UtilityException("Component must be showing on the screen to determine its location: " + component);
        }
    }

    public static List<JPopupMenu> getPopupMenus() {
        MenuElement[] selected = MenuSelectionManager.defaultManager().getSelectedPath();
        ArrayList<JPopupMenu> menus = new ArrayList<JPopupMenu>(selected.length);
        for (MenuElement element : selected) {
            if (!(element instanceof JPopupMenu)) continue;
            menus.add((JPopupMenu)element);
        }
        return menus;
    }

    public static boolean isMenuShortcutKeyDown(InputEvent event) {
        return (event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static boolean isEventDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public static void invokeLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) {
        CoreSwingUtils.invokeAndWait(runnable, false);
    }

    public static void invokeAndWait(Runnable runnable, boolean ignoreInterrupts) {
        block5: {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (InvocationTargetException e) {
                throw new UtilityException(e);
            }
            catch (InterruptedException e) {
                if (ignoreInterrupts) break block5;
                throw new UtilityException(e);
            }
        }
    }
}

