/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.FileUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.file.FileDownloadListener;
import com.alee.utils.jar.JarEntry;
import com.alee.utils.jar.JarEntryType;
import com.alee.utils.jar.JarStructure;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.LoggerFactory;

public final class JarUtils {
    private JarUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static JarStructure getJarStructure(Class jarClass) {
        return JarUtils.getJarStructure(jarClass, null, null);
    }

    public static JarStructure getJarStructure(Class jarClass, List<String> allowedExtensions, List<String> allowedPackages) {
        return JarUtils.getJarStructure(jarClass, allowedExtensions, allowedPackages, null);
    }

    public static JarStructure getJarStructure(Class jarClass, List<String> allowedExtensions, List<String> allowedPackages, FileDownloadListener listener) {
        try {
            CodeSource src = jarClass.getProtectionDomain().getCodeSource();
            if (src != null) {
                ZipEntry zipEntry;
                URL jarUrl = src.getLocation();
                URI uri = jarUrl.toURI();
                String scheme = uri.getScheme();
                File jarFile = scheme != null && scheme.equalsIgnoreCase("file") ? new File(uri) : FileUtils.downloadFile(jarUrl.toString(), File.createTempFile(jarUrl.getFile(), ".tmp"), listener);
                JarStructure jarStructure = new JarStructure();
                jarStructure.setJarLocation(jarFile.getAbsolutePath());
                JarEntry rootEntry = new JarEntry(jarStructure, JarEntryType.jarEntry, jarFile.getName());
                jarStructure.setRoot(rootEntry);
                ZipInputStream zip = new ZipInputStream(jarUrl.openStream());
                while ((zipEntry = zip.getNextEntry()) != null) {
                    String entryName = zipEntry.getName();
                    if (!JarUtils.isAllowedPackage(entryName, allowedPackages) || !zipEntry.isDirectory() && !JarUtils.isAllowedExtension(entryName, allowedExtensions)) continue;
                    JarUtils.parseElement(jarStructure, rootEntry, entryName, zipEntry);
                }
                zip.close();
                return jarStructure;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(JarUtils.class).error(e.toString(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(JarUtils.class).error(e.toString(), (Throwable)e);
        }
        return null;
    }

    public static URL getJarLocationURL(Class jarClass) {
        CodeSource src = jarClass.getProtectionDomain().getCodeSource();
        return src != null ? src.getLocation() : null;
    }

    public static File getJarLocationFile(Class jarClass) {
        try {
            URL jarUrl;
            URI uri;
            String scheme;
            CodeSource src = jarClass.getProtectionDomain().getCodeSource();
            if (src != null && (scheme = (uri = (jarUrl = src.getLocation()).toURI()).getScheme()) != null && scheme.equalsIgnoreCase("file")) {
                return new File(uri);
            }
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(JarUtils.class).error(e.toString(), (Throwable)e);
        }
        return null;
    }

    private static boolean isAllowedExtension(String entryName, List<String> allowedExtensions) {
        if (allowedExtensions == null || allowedExtensions.size() == 0) {
            return true;
        }
        String entryExt = FileUtils.getFileExtPart(entryName, true).toLowerCase(Locale.ROOT);
        return allowedExtensions.contains(entryExt);
    }

    private static boolean isAllowedPackage(String entryName, List<String> allowedPackages) {
        if (allowedPackages == null || allowedPackages.size() == 0) {
            return true;
        }
        for (String packageStart : allowedPackages) {
            if (!entryName.startsWith(packageStart)) continue;
            return true;
        }
        return false;
    }

    private static void parseElement(JarStructure jarStructure, JarEntry jarEntry, String entryName, ZipEntry zipEntry) {
        String[] path = entryName.split("/");
        JarEntry currentLevel = jarEntry;
        for (int i = 0; i < path.length; ++i) {
            if (i < path.length - 1) {
                JarEntry child = currentLevel.getChildByName(path[i]);
                if (child == null) {
                    child = new JarEntry(jarStructure, JarEntryType.packageEntry, path[i], currentLevel);
                    child.setZipEntry(zipEntry);
                    currentLevel.addChild(child);
                }
                currentLevel = child;
                continue;
            }
            JarEntry newEntry = new JarEntry(jarStructure, JarUtils.getJarEntryType(path[i]), path[i], currentLevel);
            newEntry.setZipEntry(zipEntry);
            currentLevel.addChild(newEntry);
        }
    }

    private static JarEntryType getJarEntryType(String file) {
        String ext = FileUtils.getFileExtPart(file, false);
        if (ext.equals("java")) {
            return JarEntryType.javaEntry;
        }
        if (ext.equals("class")) {
            return JarEntryType.classEntry;
        }
        if (!ext.isEmpty()) {
            return JarEntryType.fileEntry;
        }
        return JarEntryType.packageEntry;
    }
}

