/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.jdk.Objects;
import com.alee.utils.UtilityException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MapUtils {
    private MapUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean notEmpty(Map map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> Map<K, V> nonNull(Map<K, V> map) {
        return map != null ? map : new HashMap(0);
    }

    public static <K, V> HashMap<K, V> copyMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> HashMap<K, V> copyHashMap(HashMap<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> copyLinkedHashMap(LinkedHashMap<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<K, V> data) {
        return new HashMap<K, V>(data);
    }

    public static <K, V> HashMap<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(Object ... objects) {
        if (objects != null && objects.length > 0) {
            if (objects.length % 2 == 0) {
                HashMap<Object, Object> map = new HashMap<Object, Object>(1);
                for (int i = 0; i < objects.length; i += 2) {
                    map.put(objects[i], objects[i + 1]);
                }
                return map;
            }
            throw new RuntimeException("Amount of key-value objects must be even");
        }
        return new HashMap(0);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(K key, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(1);
        map.put(key, value);
        return map;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Object ... objects) {
        if (objects != null && objects.length > 0) {
            if (objects.length % 2 == 0) {
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(1);
                for (int i = 0; i < objects.length; i += 2) {
                    map.put(objects[i], objects[i + 1]);
                }
                return map;
            }
            throw new RuntimeException("Amount of key-value objects must be even");
        }
        return new LinkedHashMap(0);
    }

    public static <K, V> void removeAllValues(Map<K, V> map, V value) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (!Objects.equals(entry.getValue(), value)) continue;
            iterator.remove();
        }
    }

    public static <K, V> HashMap<K, V> merge(Map<K, V> ... maps) {
        int size = 0;
        for (Map<K, V> map : maps) {
            if (map == null) continue;
            size += map.size();
        }
        HashMap<K, V> merged = new HashMap<K, V>(size);
        for (Map<K, V> map : maps) {
            if (map == null) continue;
            merged.putAll(map);
        }
        return merged;
    }
}

