/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.jdk.Supplier;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ShapeUtils {
    private static final Map<Component, Map<String, CachedShape>> shapeCache = new WeakHashMap<Component, Map<String, CachedShape>>();

    private ShapeUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static Shape createRoundedShape(int round, Point ... points) {
        if (round > 0) {
            int[] r = new int[points.length];
            Arrays.fill(r, round);
            return ShapeUtils.createRoundedShape(points, r);
        }
        return ShapeUtils.createRoundedShape(points, null);
    }

    public static Shape createRoundedShape(Point[] points, int[] round) {
        if (points == null || points.length < 3) {
            throw new RuntimeException("There should be at least three points presented");
        }
        if (round != null && round.length != points.length) {
            throw new RuntimeException("Round array size should fit points array size");
        }
        GeneralPath gp = new GeneralPath(0);
        for (int i = 0; i < points.length; ++i) {
            Point p = points[i];
            if (i == 0) {
                Point beforePoint = points[points.length - 1];
                if (round != null && round[points.length - 1] <= 0) {
                    gp.moveTo(beforePoint.x, beforePoint.y);
                } else {
                    Point actualBeforePoint = ShapeUtils.getRoundSidePoint(round[points.length - 1], beforePoint, p);
                    gp.moveTo(actualBeforePoint.x, actualBeforePoint.y);
                }
                if (round != null && round[i] <= 0) {
                    gp.lineTo(p.x, p.y);
                    continue;
                }
                Point before = ShapeUtils.getRoundSidePoint(round[i], p, beforePoint);
                Point after = ShapeUtils.getRoundSidePoint(round[i], p, points[i + 1]);
                gp.lineTo(before.x, before.y);
                gp.quadTo(p.x, p.y, after.x, after.y);
                continue;
            }
            if (round != null && round[i] <= 0) {
                gp.lineTo(p.x, p.y);
                continue;
            }
            Point before = ShapeUtils.getRoundSidePoint(round[i], p, points[i - 1]);
            Point after = ShapeUtils.getRoundSidePoint(round[i], p, points[i < points.length - 1 ? i + 1 : 0]);
            gp.lineTo(before.x, before.y);
            gp.quadTo(p.x, p.y, after.x, after.y);
        }
        return gp;
    }

    private static Point getRoundSidePoint(int round, Point from, Point to) {
        if (from.y == to.y) {
            if (from.x < to.x) {
                return new Point(from.x + Math.min(round, (to.x - from.x) / 2), from.y);
            }
            return new Point(from.x - Math.min(round, (from.x - to.x) / 2), from.y);
        }
        if (from.x == to.x) {
            if (from.y < to.y) {
                return new Point(from.x, from.y + Math.min(round, (to.y - from.y) / 2));
            }
            return new Point(from.x, from.y - Math.min(round, (from.y - to.y) / 2));
        }
        throw new RuntimeException("Non-90-degree corners are not supported");
    }

    public static <T extends Shape> T getShape(Component component, String shapeId, Supplier<T> shapeSupplier, Object ... settings) {
        String settingsKey = TextUtils.getSettingsKey(settings);
        Map<String, CachedShape> cacheById = shapeCache.get(component);
        if (cacheById == null) {
            Shape shape = (Shape)shapeSupplier.get();
            cacheById = new HashMap<String, CachedShape>(1);
            cacheById.put(shapeId, new CachedShape(settingsKey, shape));
            shapeCache.put(component, cacheById);
            return (T)shape;
        }
        CachedShape cachedShape = cacheById.get(shapeId);
        if (cachedShape == null || !cachedShape.getKey().equals(settingsKey)) {
            Shape shape = (Shape)shapeSupplier.get();
            cacheById.put(shapeId, new CachedShape(settingsKey, shape));
            return (T)shape;
        }
        return (T)cachedShape.getShape();
    }

    private static class CachedShape {
        private final String key;
        private final Shape shape;

        public CachedShape(String key, Shape shape) {
            this.key = key;
            this.shape = shape;
        }

        private String getKey() {
            return this.key;
        }

        private Shape getShape() {
            return this.shape;
        }
    }
}

