/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.jdk.Function;
import com.alee.api.jdk.Supplier;
import com.alee.managers.language.LM;
import com.alee.utils.CollectionUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.compare.Filter;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.InsetsConverter;
import com.alee.utils.xml.PointConverter;
import com.alee.utils.xml.RectangleConverter;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public final class TextUtils {
    private static final List<Character> textSeparators = CollectionUtils.asList(Character.valueOf(' '), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('/'), Character.valueOf('|'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\\'), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\''), Character.valueOf('\''), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('%'), Character.valueOf('$'), Character.valueOf('#'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('~'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('?'));
    private static final Function<Object, String> simpleTextProvider = new Function<Object, String>(){

        @Override
        public String apply(Object object) {
            return object != null ? object.toString() : "null";
        }
    };
    private static final int idPartLength = 5;
    private static final String defaultIdPrefix = "WebLaF";
    private static final String defaultIdSuffix = "ID";
    private static final String defaultSeparator = ",";
    private static String systemLineSeparator;

    private TextUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static String getSystemLineSeparator() {
        if (systemLineSeparator == null) {
            try {
                systemLineSeparator = System.getProperty("line.separator");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (systemLineSeparator == null) {
                systemLineSeparator = "\n";
            }
        }
        return systemLineSeparator;
    }

    public static String format(String text, Object ... objects) {
        Object[] data = new Object[objects != null ? objects.length : 0];
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                data[i] = TextUtils.toString(objects[i]);
            }
        }
        return String.format(text, data);
    }

    public static String replace(String text, int index, char character) {
        StringBuilder sb = new StringBuilder(text);
        sb.setCharAt(index, character);
        return sb.toString();
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static boolean equals(String string, String compareWith) {
        return string == compareWith || string != null && string.equals(compareWith);
    }

    public static boolean equalsIgnoreCase(String string, String compareWith) {
        return string == compareWith || string != null && string.equalsIgnoreCase(compareWith);
    }

    public static List<String> numbered(String pattern, int from, int to) {
        ArrayList<String> list = new ArrayList<String>(Math.abs(from - to));
        if (from < to) {
            for (int i = from; i <= to; ++i) {
                list.add(TextUtils.format(pattern, i));
            }
        } else {
            for (int i = from; i >= to; --i) {
                list.add(TextUtils.format(pattern, i));
            }
        }
        return list;
    }

    public static String removeLineBreaks(String text) {
        return text.replaceAll("\\r\\n|\\r|\\n", "");
    }

    public static String removeSpacings(String text) {
        return text.replaceAll("[ \\t]", "");
    }

    public static Integer findFirstNumber(String text) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < text.length(); ++j) {
            char ch = text.charAt(j);
            if (Character.isDigit(ch)) {
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) break;
        }
        return Integer.parseInt(sb.toString());
    }

    public static String getWord(String text, int location) {
        String word;
        if (0 <= location && location < text.length()) {
            if (!textSeparators.contains(Character.valueOf(text.charAt(location)))) {
                int wordEnd;
                int wordStart = location;
                for (wordEnd = location; wordEnd < text.length() - 1 && !textSeparators.contains(Character.valueOf(text.charAt(wordEnd))); ++wordEnd) {
                }
                while (wordStart > 0 && !textSeparators.contains(Character.valueOf(text.charAt(wordStart - 1)))) {
                    --wordStart;
                }
                word = wordStart == wordEnd ? null : text.substring(wordStart, wordEnd);
            } else {
                word = null;
            }
        } else {
            word = null;
        }
        return word;
    }

    public static int getWordStart(String text, int location) {
        int start;
        if (0 <= location && location < text.length()) {
            if (!textSeparators.contains(Character.valueOf(text.charAt(location)))) {
                int wordStart;
                for (wordStart = location; wordStart > 0 && !textSeparators.contains(Character.valueOf(text.charAt(wordStart - 1))); --wordStart) {
                }
                start = wordStart;
            } else {
                start = -1;
            }
        } else {
            start = -1;
        }
        return start;
    }

    public static int getWordEnd(String text, int location) {
        int end;
        if (0 <= location && location < text.length()) {
            if (!textSeparators.contains(Character.valueOf(text.charAt(location)))) {
                int wordEnd;
                for (wordEnd = location; wordEnd < text.length() && !textSeparators.contains(Character.valueOf(text.charAt(wordEnd))); ++wordEnd) {
                }
                end = wordEnd;
            } else {
                end = -1;
            }
        } else {
            end = -1;
        }
        return end;
    }

    public static int findLastRowWordStartIndex(String string) {
        boolean spaceFound = false;
        boolean skipSpace = true;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (!spaceFound && !skipSpace) {
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
                spaceFound = true;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            if (spaceFound) {
                return i;
            }
            skipSpace = false;
        }
        return -1;
    }

    public static int findFirstWordFromIndex(String string, int from) {
        for (int i = from; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return i;
        }
        return -1;
    }

    public static int findFirstRowWordEndIndex(String string) {
        boolean spaceFound = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!spaceFound) {
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
                spaceFound = true;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return i;
        }
        return string.length();
    }

    public static String removeFirstLines(String text, int count) {
        int index = 0;
        for (int found = 0; found < count; ++found) {
            if ((index = text.indexOf("\n", index)) != -1) {
                ++index;
                continue;
            }
            return "";
        }
        return text.substring(index);
    }

    public static Point parsePoint(String text) {
        return TextUtils.parsePoint(text, defaultSeparator);
    }

    public static Point parsePoint(String text, String separator) {
        String[] parts = text.split(separator);
        return parts.length == 2 ? new Point(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim())) : null;
    }

    public static String removeControlSymbols(String text) {
        int length = text.length();
        char[] oldChars = new char[length];
        text.getChars(0, length, oldChars, 0);
        int newLen = 0;
        for (int j = 0; j < length; ++j) {
            char ch = oldChars[j];
            if (ch < ' ') continue;
            oldChars[newLen] = ch;
            ++newLen;
        }
        return text;
    }

    public static String shortenText(String text, int maxLength, boolean addDots) {
        return text.length() <= maxLength ? text : text.substring(0, maxLength > 3 && addDots ? maxLength - 3 : maxLength) + (addDots ? "..." : "");
    }

    public static String shortenTextEnd(String text, int maxLength, boolean addDots) {
        return text.length() <= maxLength ? text : (addDots ? "..." : "") + text.substring(text.length() - (maxLength > 3 && addDots ? maxLength - 3 : maxLength));
    }

    public static List<String> stringToList(String string) {
        return TextUtils.stringToList(string, defaultSeparator);
    }

    public static List<String> stringToList(String string, String separator) {
        ArrayList<String> strings = new ArrayList<String>();
        if (string != null) {
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            while (tokenizer.hasMoreTokens()) {
                strings.add(tokenizer.nextToken().trim());
            }
        }
        return strings;
    }

    public static List<Integer> stringToIntList(String string) {
        return TextUtils.stringToIntList(string, defaultSeparator);
    }

    public static List<Integer> stringToIntList(String string, String separator) {
        List<String> stringList = TextUtils.stringToList(string, separator);
        if (stringList != null) {
            ArrayList<Integer> intList = new ArrayList<Integer>(stringList.size());
            for (String s : stringList) {
                intList.add(Integer.parseInt(s));
            }
            return intList;
        }
        return null;
    }

    public static List<Float> stringToFloatList(String string) {
        return TextUtils.stringToFloatList(string, defaultSeparator);
    }

    public static List<Float> stringToFloatList(String string, String separator) {
        List<String> stringList = TextUtils.stringToList(string, separator);
        if (stringList != null) {
            ArrayList<Float> intList = new ArrayList<Float>(stringList.size());
            for (String s : stringList) {
                intList.add(Float.valueOf(Float.parseFloat(s)));
            }
            return intList;
        }
        return null;
    }

    public static <T> String listToString(List<T> list) {
        return TextUtils.listToString(list, defaultSeparator);
    }

    public static <T> String listToString(List<T> list, String separator) {
        return TextUtils.listToString(list, separator, simpleTextProvider);
    }

    public static <T> String listToString(List<T> list, String separator, Function<T, String> textProvider) {
        return TextUtils.listToString(list, separator, textProvider, null);
    }

    public static <T> String listToString(List<T> list, String separator, Function<T, String> textProvider, Filter<T> filter) {
        if (CollectionUtils.notEmpty(list)) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean hasPreviouslyAccepted = false;
            for (T object : list) {
                if (filter != null && !filter.accept(object)) continue;
                if (hasPreviouslyAccepted) {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(textProvider.apply(object));
                hasPreviouslyAccepted = true;
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static <T> String arrayToString(T ... array) {
        return TextUtils.arrayToString(defaultSeparator, array);
    }

    public static <T> String arrayToString(String separator, T ... array) {
        return TextUtils.arrayToString(separator, simpleTextProvider, array);
    }

    public static <T> String arrayToString(String separator, Function<T, String> textProvider, T ... array) {
        return TextUtils.arrayToString(separator, textProvider, null, array);
    }

    public static <T> String arrayToString(String separator, Function<T, String> textProvider, Filter<T> filter, T ... array) {
        if (array != null && array.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean hasPreviouslyAccepted = false;
            for (T object : array) {
                if (filter != null && !filter.accept(object)) continue;
                if (hasPreviouslyAccepted) {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(textProvider.apply(object));
                hasPreviouslyAccepted = true;
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static <E extends Enum<E>> String enumArrayToString(E ... enumArray) {
        return TextUtils.enumArrayToString((String)defaultSeparator, enumArray);
    }

    public static <E extends Enum<E>> String enumArrayToString(String separator, E ... enumArray) {
        if (enumArray != null && enumArray.length > 0) {
            int end = enumArray.length - 1;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i <= end; ++i) {
                stringBuilder.append(enumArray[i]);
                stringBuilder.append(i != end ? separator : "");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static <E extends Enum<E>> String enumListToString(List<E> enumList) {
        return TextUtils.enumListToString(enumList, defaultSeparator);
    }

    public static <E extends Enum<E>> String enumListToString(List<E> enumList, String separator) {
        if (enumList != null && enumList.size() > 0) {
            int end = enumList.size() - 1;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i <= end; ++i) {
                stringBuilder.append(enumList.get(i));
                stringBuilder.append(i != end ? separator : "");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static <E extends Enum<E>> List<E> enumStringToList(String enumString, Class<E> enumClass) {
        return TextUtils.enumStringToList(enumString, enumClass, defaultSeparator);
    }

    public static <E extends Enum<E>> List<E> enumStringToList(String enumString, Class<E> enumClass, String separator) {
        ArrayList<E> enumerations;
        if (enumString != null) {
            StringTokenizer tokenizer = new StringTokenizer(enumString, separator, false);
            enumerations = new ArrayList();
            while (tokenizer.hasMoreTokens()) {
                enumerations.add(Enum.valueOf(enumClass, tokenizer.nextToken().trim()));
            }
        } else {
            enumerations = new ArrayList<E>(0);
        }
        return enumerations;
    }

    public static String unite(String separator, String ... parts) {
        if (parts != null && parts.length > 0) {
            StringBuilder sb = new StringBuilder();
            boolean hasPrevious = false;
            for (String part : parts) {
                if (TextUtils.isEmpty(part)) continue;
                if (hasPrevious) {
                    sb.append(separator);
                }
                sb.append(part);
                hasPrevious = true;
            }
            return sb.toString();
        }
        return "";
    }

    public static int length(String text) {
        return text != null ? text.length() : 0;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean notEmpty(String text) {
        return !TextUtils.isEmpty(text);
    }

    public static boolean isBlank(String text) {
        return text == null || text.isEmpty() || TextUtils.removeLineBreaks(text).trim().isEmpty();
    }

    public static boolean notBlank(String text) {
        return !TextUtils.isBlank(text);
    }

    public static String requireNonEmpty(String text) {
        return TextUtils.requireNonEmpty(text, "Text must not be empty");
    }

    public static String requireNonEmpty(String text, String message) {
        if (TextUtils.isEmpty(text)) {
            throw new NullPointerException(LM.contains(message) ? LM.get(message, new Object[0]) : message);
        }
        return text;
    }

    public static String requireNonEmpty(String text, Supplier<RuntimeException> exceptionSupplier) {
        if (TextUtils.isEmpty(text)) {
            throw exceptionSupplier.get();
        }
        return text;
    }

    public static String createString(String character, int length) {
        return TextUtils.createString(character.charAt(0), length);
    }

    public static String createString(char character, int length) {
        char[] characters = new char[length];
        Arrays.fill(characters, character);
        return new String(characters);
    }

    public static String replaceAll(String text, boolean ignoreCase, String str, Function<String, String> replacer) {
        String exp = ignoreCase ? str.toLowerCase(Locale.ROOT) : str;
        int match = 0;
        int prev = 0;
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            match = exp.charAt(match) == (ignoreCase ? Character.toLowerCase(ch) : ch) ? ++match : (exp.charAt(0) == (ignoreCase ? Character.toLowerCase(ch) : ch) ? 1 : 0);
            if (match == exp.length()) {
                int start = i - exp.length() + 1;
                String part = text.substring(start, start + exp.length());
                builder.append(text, prev, start);
                builder.append(replacer.apply(part));
                prev = start + exp.length();
                match = 0;
                continue;
            }
            if (i != text.length() - 1) continue;
            builder.append(text.substring(prev));
        }
        return builder.toString();
    }

    public static String generateId() {
        return TextUtils.generateId(null, null);
    }

    public static String generateId(String prefix) {
        return TextUtils.generateId(prefix, null);
    }

    public static String generateId(String prefix, String suffix) {
        return (prefix == null ? defaultIdPrefix : prefix) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + (suffix == null ? defaultIdSuffix : suffix);
    }

    public static String generateId(int length) {
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int next = 0;
            int range = 10;
            switch (MathUtils.random(3)) {
                case 0: {
                    next = 48;
                    range = 10;
                    break;
                }
                case 1: {
                    next = 97;
                    range = 26;
                    break;
                }
                case 2: {
                    next = 65;
                    range = 26;
                }
            }
            stringBuilder.append((char)(MathUtils.random(range) + next));
        }
        return stringBuilder.toString();
    }

    public static String getSettingsKey(Object ... settings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : settings) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            if (object != null) {
                if (object.getClass().isArray()) {
                    int length = Array.getLength(object);
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(";");
                        }
                        stringBuilder.append(TextUtils.getSettingsKey(Array.get(object, i)));
                    }
                    continue;
                }
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    stringBuilder.append(TextUtils.getSettingsKey(collection.toArray()));
                    continue;
                }
                stringBuilder.append(TextUtils.getSettingKey(object));
                continue;
            }
            stringBuilder.append(TextUtils.getSettingKey(null));
        }
        return stringBuilder.toString();
    }

    private static String getSettingKey(Object setting) {
        if (setting == null) {
            return "null";
        }
        if (setting instanceof Insets) {
            return InsetsConverter.insetsToString((Insets)setting);
        }
        if (setting instanceof Rectangle) {
            return RectangleConverter.rectangleToString((Rectangle)setting);
        }
        if (setting instanceof Point) {
            return PointConverter.pointToString((Point)setting);
        }
        if (setting instanceof Color) {
            return ColorConverter.colorToString((Color)setting);
        }
        return setting.toString();
    }
}

