/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.UtilityException;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class WebUtils {
    private WebUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static String normalizeUrl(String url) {
        try {
            return new URI(url).normalize().toASCIIString();
        }
        catch (URISyntaxException e) {
            return url;
        }
    }

    public static Map<String, List<String>> getUrlParameters(String url) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        String[] urlParts = url.split("\\?");
        if (urlParts.length > 1) {
            String query = urlParts[1];
            for (String param : query.split("&")) {
                ArrayList<String> values;
                String[] pair = param.split("=");
                String key = WebUtils.decodeUrl(pair[0]);
                String value = "";
                if (pair.length > 1) {
                    value = WebUtils.decodeUrl(pair[1]);
                }
                if ((values = (ArrayList<String>)params.get(key)) == null) {
                    values = new ArrayList<String>();
                    params.put(key, values);
                }
                values.add(value);
            }
        }
        return params;
    }

    public static String encodeUrl(String url) {
        try {
            URL u = new URL(url);
            URI uri = new URI(u.getProtocol(), u.getHost(), u.getPath(), u.getQuery(), null);
            return uri.toASCIIString();
        }
        catch (Exception e) {
            return url;
        }
    }

    public static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static void browseSite(String address) throws URISyntaxException, IOException {
        Desktop.getDesktop().browse(new URI(address));
    }

    public static void browseSiteSafely(String address) {
        try {
            WebUtils.browseSite(address);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void shareOnTwitter(final String address) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebUtils.browseSiteSafely("http://twitter.com/intent/tweet?text=" + address);
            }
        }).start();
    }

    public static void shareOnVk(final String address) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebUtils.browseSiteSafely("http://vkontakte.ru/share.php?url=" + address);
            }
        }).start();
    }

    public static void shareOnFb(final String address) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebUtils.browseSiteSafely("http://www.facebook.com/sharer.php?u=" + address);
            }
        }).start();
    }

    public static void openFile(File file) throws IOException {
        Desktop.getDesktop().open(file);
    }

    public static void openFileSafely(File file) {
        try {
            WebUtils.openFile(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeEmail(String email) throws URISyntaxException, IOException {
        WebUtils.writeEmail(email, null, null);
    }

    public static void writeEmail(String email, String subject, String body) throws URISyntaxException, IOException {
        URI uri;
        if (!email.startsWith("mailto:")) {
            email = "mailto:" + email;
        }
        if (subject != null && body != null) {
            subject = subject.replaceAll(" ", "%20");
            body = body.replaceAll(" ", "%20");
            uri = new URI(email + "?subject=" + subject + "&body=" + body);
        } else {
            uri = new URI(email);
        }
        Desktop.getDesktop().mail(uri);
    }

    public static void writeEmailSafely(String email) {
        try {
            WebUtils.writeEmail(email);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeEmailSafely(String email, String subject, String body) {
        try {
            WebUtils.writeEmail(email, subject, body);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

