/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.general.Pair;
import com.alee.utils.xml.AliasProvider;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.DimensionConverter;
import com.alee.utils.xml.InsetsConverter;
import com.alee.utils.xml.Point2DConverter;
import com.alee.utils.xml.Resource;
import com.alee.utils.xml.ResourceLocation;
import com.alee.utils.xml.StrokeConverter;
import com.alee.utils.xml.XStreamContext;
import com.alee.utils.xml.XmlDriver;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import org.slf4j.LoggerFactory;

public final class XmlUtils {
    private static boolean aliasJdkClasses = true;
    private static HierarchicalStreamDriver hierarchicalStreamDriver;
    private static XStream xStream;

    private XmlUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static XStream getXStream() {
        if (xStream == null) {
            XmlUtils.initializeXStream();
        }
        return xStream;
    }

    private static void initializeXStream() {
        try {
            PureJavaReflectionProvider reflectionProvider = new PureJavaReflectionProvider();
            hierarchicalStreamDriver = new XmlDriver();
            xStream = new XStream((ReflectionProvider)reflectionProvider, hierarchicalStreamDriver);
            if (XmlUtils.class.getClassLoader() != xStream.getClass().getClassLoader()) {
                ClassLoader classLoader = xStream.getClassLoader();
                if (classLoader instanceof CompositeClassLoader) {
                    ((CompositeClassLoader)classLoader).add(XmlUtils.class.getClassLoader());
                } else {
                    CompositeClassLoader compositeClassLoader = new CompositeClassLoader();
                    compositeClassLoader.add(XmlUtils.class.getClassLoader());
                    xStream.setClassLoader((ClassLoader)compositeClassLoader);
                }
            }
            if (aliasJdkClasses) {
                xStream.alias("Point", Point.class);
                xStream.useAttributeFor(Point.class, "x");
                xStream.useAttributeFor(Point.class, "y");
                xStream.alias("Point2D", Point2D.class);
                xStream.registerConverter((SingleValueConverter)new Point2DConverter());
                xStream.alias("Dimension", Dimension.class);
                xStream.registerConverter((SingleValueConverter)new DimensionConverter());
                xStream.alias("Rectangle", Rectangle.class);
                xStream.useAttributeFor(Rectangle.class, "x");
                xStream.useAttributeFor(Rectangle.class, "y");
                xStream.useAttributeFor(Rectangle.class, "width");
                xStream.useAttributeFor(Rectangle.class, "height");
                xStream.alias("Font", Font.class);
                xStream.alias("Color", Color.class);
                xStream.registerConverter((SingleValueConverter)new ColorConverter());
                xStream.alias("Insets", Insets.class);
                xStream.registerConverter((SingleValueConverter)new InsetsConverter());
                xStream.alias("Stroke", Stroke.class);
                xStream.registerConverter((SingleValueConverter)new StrokeConverter());
            }
            xStream.processAnnotations(ResourceLocation.class);
            xStream.processAnnotations(Resource.class);
            xStream.processAnnotations(Pair.class);
        }
        catch (Exception e) {
            throw new UtilityException("Unable to initialize XStream instance", e);
        }
    }

    public static boolean isAliasJdkClasses() {
        return aliasJdkClasses;
    }

    public static void setAliasJdkClasses(boolean alias) {
        aliasJdkClasses = alias;
    }

    public static void processAnnotations(Class type) {
        XmlUtils.getXStream().processAnnotations(type);
    }

    public static void processAnnotations(Class[] types) {
        XmlUtils.getXStream().processAnnotations(types);
    }

    public static void alias(String name, Class type) {
        XmlUtils.getXStream().alias(name, type);
    }

    public static void omitField(Class type, String field) {
        XmlUtils.getXStream().omitField(type, field);
    }

    public static void useAttributeFor(Class type, String field) {
        XmlUtils.getXStream().useAttributeFor(type, field);
    }

    public static void addImplicitArray(Class type, String field) {
        XmlUtils.getXStream().addImplicitArray(type, field);
    }

    public static void addImplicitArray(Class type, String field, String itemName) {
        XmlUtils.getXStream().addImplicitArray(type, field, itemName);
    }

    public static void registerConverter(Converter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static void registerConverter(SingleValueConverter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static <T extends AliasProvider> void alias(Class<T> aliasProvider) {
        ReflectUtils.callStaticMethodSafely(aliasProvider, "provideAliases", XmlUtils.getXStream());
    }

    public static <T> T fromXML(Reader reader) {
        return (T)XmlUtils.getXStream().fromXML(reader);
    }

    public static <T> T fromXML(Reader reader, XStreamContext context) {
        return (T)XmlUtils.getXStream().unmarshal(hierarchicalStreamDriver.createReader(reader), null, (DataHolder)context);
    }

    public static <T> T fromXML(InputStream input) {
        return (T)XmlUtils.getXStream().fromXML(input);
    }

    public static <T> T fromXML(InputStream input, XStreamContext context) {
        return (T)XmlUtils.getXStream().unmarshal(hierarchicalStreamDriver.createReader(input), null, (DataHolder)context);
    }

    public static <T> T fromXML(URL url) {
        return (T)XmlUtils.getXStream().fromXML(url);
    }

    public static <T> T fromXML(URL url, XStreamContext context) {
        return (T)XmlUtils.getXStream().unmarshal(hierarchicalStreamDriver.createReader(url), null, (DataHolder)context);
    }

    public static <T> T fromXML(File file) {
        return (T)XmlUtils.getXStream().fromXML(file);
    }

    public static <T> T fromXML(File file, XStreamContext context) {
        return (T)XmlUtils.getXStream().unmarshal(hierarchicalStreamDriver.createReader(file), null, (DataHolder)context);
    }

    public static <T> T fromXML(String xml) {
        return (T)XmlUtils.getXStream().fromXML(xml);
    }

    public static <T> T fromXML(String xml, XStreamContext context) {
        return (T)XmlUtils.getXStream().unmarshal(hierarchicalStreamDriver.createReader((Reader)new StringReader(xml)), null, (DataHolder)context);
    }

    public static <T> T fromXML(Resource resource) {
        return XmlUtils.fromXML(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromXML(Resource resource, XStreamContext context) {
        try {
            switch (resource.getLocation()) {
                case url: {
                    return XmlUtils.fromXML(new URL(resource.getPath()), context);
                }
                case filePath: {
                    return XmlUtils.fromXML(new File(resource.getPath()), context);
                }
                case nearClass: {
                    InputStream is = null;
                    try {
                        is = Class.forName(resource.getClassName()).getResourceAsStream(resource.getPath());
                        if (is == null) {
                            String src = resource.getPath();
                            String cn = resource.getClassName();
                            String msg = "Unable to read XML file '%s' near class: %s";
                            throw new RuntimeException(String.format("Unable to read XML file '%s' near class: %s", src, cn));
                        }
                        T t = XmlUtils.fromXML(is, context);
                        return t;
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            throw new RuntimeException("Unknown resource location type: " + resource.getLocation());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to deserialize object from XML", e);
        }
    }

    public static void toXML(Object obj, String file) {
        XmlUtils.toXML(obj, new File(file));
    }

    public static void toXML(Object obj, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            XmlUtils.toXML(obj, osw);
            osw.close();
            fos.close();
        }
        catch (IOException e) {
            String msg = "Unable to serialize object '%s' into XML and write it into file: %s";
            LoggerFactory.getLogger(XmlUtils.class).error(TextUtils.format("Unable to serialize object '%s' into XML and write it into file: %s", obj, file), (Throwable)e);
        }
    }

    public static String toXML(Object obj) {
        return XmlUtils.getXStream().toXML(obj);
    }

    public static void toXML(Object obj, Writer out) {
        XmlUtils.getXStream().toXML(obj, out);
    }

    public static void toXML(Object obj, OutputStream out) {
        XmlUtils.getXStream().toXML(obj, out);
    }

    public static void toXML(Object obj, HierarchicalStreamWriter writer) {
        XmlUtils.getXStream().marshal(obj, writer);
    }

    static {
        xStream = null;
    }
}

