/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.array;

import com.alee.utils.array.ArrayIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayListIterator<E>
extends ArrayIterator<E>
implements ListIterator<E> {
    public ArrayListIterator(E ... array) {
        super(array);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public E previous() {
        if (this.index > 0) {
            return (E)this.array[--this.index];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.index < this.array.length ? this.index + 1 : this.array.length;
    }

    @Override
    public int previousIndex() {
        return this.index > 0 ? this.index - 1 : -1;
    }

    @Override
    public void set(E e) {
        this.array[this.index] = e;
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException("Cannot add array elements");
    }
}

