/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.api.jdk.Supplier;
import java.util.ArrayList;
import java.util.Collection;

public class ArrayListAggregator<T> {
    private final ArrayList<T> list = new ArrayList();

    public ArrayListAggregator<T> add(T element) {
        this.list.add(element);
        return this;
    }

    public ArrayListAggregator<T> add(boolean condition, T element) {
        if (condition) {
            this.list.add(element);
        }
        return this;
    }

    public ArrayListAggregator<T> add(Supplier<Boolean> condition, T element) {
        if (condition.get().booleanValue()) {
            this.list.add(element);
        }
        return this;
    }

    public ArrayListAggregator<T> addAll(Collection<? extends T> collection) {
        this.list.addAll(collection);
        return this;
    }

    public ArrayListAggregator<T> addAll(boolean condition, Collection<? extends T> collection) {
        if (condition) {
            this.list.addAll(collection);
        }
        return this;
    }

    public ArrayListAggregator<T> addAll(Supplier<Boolean> condition, Collection<? extends T> collection) {
        if (condition.get().booleanValue()) {
            this.list.addAll(collection);
        }
        return this;
    }

    public ArrayList<T> toList() {
        return this.list;
    }
}

