/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.api.jdk.Objects;
import com.alee.utils.CollectionUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ImmutableSet<E>
implements Set<E>,
Cloneable,
Serializable {
    protected final HashSet<E> data;

    public ImmutableSet(E ... data) {
        if (data == null) {
            throw new NullPointerException("ImmutableSet data must not be null");
        }
        this.data = CollectionUtils.asHashSet(data);
    }

    public ImmutableSet(Collection<? extends E> data) {
        if (data == null) {
            throw new NullPointerException("ImmutableSet data must not be null");
        }
        this.data = new HashSet<E>(data);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this.data.contains(element);
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.data.toArray(array);
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public boolean add(E element) {
        throw this.createModificationException();
    }

    @Override
    public boolean remove(Object element) {
        throw this.createModificationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.data.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw this.createModificationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw this.createModificationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw this.createModificationException();
    }

    @Override
    public void clear() {
        throw this.createModificationException();
    }

    protected UnsupportedOperationException createModificationException() {
        return new UnsupportedOperationException("ImmutableSet is unmodifiable");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data.toArray());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableSet) {
            ImmutableSet other = (ImmutableSet)o;
            return CollectionUtils.equals(this.data, other.data);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.data.toArray());
    }
}

