/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet<E>
extends AbstractSet<E> {
    protected WeakHashMap<E, Boolean> map;
    protected transient Set<E> keySet;

    public WeakHashSet() {
        this(10);
    }

    public WeakHashSet(int initialCapacity) {
        this.map = new WeakHashMap(initialCapacity);
        this.keySet = this.map.keySet();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, Boolean.TRUE) == null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.keySet.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.keySet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.keySet.toArray(a);
    }

    @Override
    public String toString() {
        return this.keySet.toString();
    }

    @Override
    public int hashCode() {
        return this.keySet.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Set && this.keySet.equals(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.keySet.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.keySet.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.keySet.retainAll(c);
    }
}

