/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.filefilter;

import com.alee.api.ui.RenderingParameters;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.filefilter.FilterGroupType;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class GroupedFileFilter
extends AbstractFileFilter {
    protected FilterGroupType filterGroupType;
    protected AbstractFileFilter defaultFilter;
    protected List<FileFilter> filters;

    public GroupedFileFilter(FileFilter ... filters) {
        this(FilterGroupType.AND, filters);
    }

    public GroupedFileFilter(FilterGroupType filterGroupType, FileFilter ... filters) {
        this(filters != null && filters.length > 0 && filters[0] instanceof AbstractFileFilter ? (AbstractFileFilter)filters[0] : null, filterGroupType, filters);
    }

    public GroupedFileFilter(AbstractFileFilter defaultFilter, FilterGroupType filterGroupType, FileFilter ... filters) {
        this.filterGroupType = filterGroupType;
        this.defaultFilter = defaultFilter;
        this.filters = new ArrayList<FileFilter>();
        if (filters != null) {
            Collections.addAll(this.filters, filters);
        }
    }

    @Override
    public Icon getIcon(RenderingParameters parameters) {
        return this.defaultFilter != null ? this.defaultFilter.getIcon(parameters) : null;
    }

    @Override
    public String getDescription() {
        return this.defaultFilter != null ? this.defaultFilter.getDescription() : null;
    }

    @Override
    public boolean accept(File file) {
        if (this.filterGroupType.equals((Object)FilterGroupType.AND)) {
            for (FileFilter filter : this.filters) {
                if (filter == null || filter.accept(file)) continue;
                return false;
            }
            return true;
        }
        for (FileFilter filter : this.filters) {
            if (filter != null && !filter.accept(file)) continue;
            return true;
        }
        return false;
    }
}

