/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.jar;

import com.alee.utils.FileUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.jar.JarEntryType;
import com.alee.utils.jar.JarStructure;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;

public class JarEntry {
    public static final String ID_PREFIX = "JE";
    private String id;
    private JarEntryType type;
    private String name;
    private ImageIcon icon;
    private ZipEntry zipEntry;
    private JarStructure structure;
    private JarEntry parent;
    private List<JarEntry> children = new ArrayList<JarEntry>();

    public JarEntry(JarStructure structure) {
        this.setStructure(structure);
        this.setParent(null);
    }

    public JarEntry(JarStructure structure, JarEntryType type, String name) {
        this.setType(type);
        this.setName(name);
        this.setStructure(structure);
        this.setParent(null);
    }

    public JarEntry(JarStructure structure, JarEntryType type, String name, JarEntry parent) {
        this.setType(type);
        this.setName(name);
        this.setStructure(structure);
        this.setParent(parent);
    }

    public JarEntry(JarStructure structure, JarEntryType type, String name, JarEntry parent, List<JarEntry> children) {
        this.setType(type);
        this.setName(name);
        this.setStructure(structure);
        this.setParent(parent);
        this.setChildren(children);
    }

    public String getId() {
        if (this.id == null) {
            this.setId();
        }
        return this.id;
    }

    private void setId() {
        this.setId(TextUtils.generateId(ID_PREFIX));
    }

    public void setId(String id) {
        this.id = id;
    }

    public JarEntryType getType() {
        return this.type;
    }

    public void setType(JarEntryType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public void setZipEntry(ZipEntry zipEntry) {
        this.zipEntry = zipEntry;
    }

    public JarStructure getStructure() {
        return this.structure;
    }

    public void setStructure(JarStructure structure) {
        this.structure = structure;
    }

    public JarEntry getParent() {
        return this.parent;
    }

    public void setParent(JarEntry parent) {
        this.parent = parent;
    }

    public List<JarEntry> getChildren() {
        return this.children;
    }

    public JarEntry getChild(int index) {
        return this.children.get(index);
    }

    public JarEntry getChildByName(String name) {
        for (JarEntry child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public void setChildren(List<JarEntry> children) {
        this.children = children;
    }

    public void addChild(JarEntry child) {
        this.children.add(child);
    }

    public void addChild(int index, JarEntry child) {
        this.children.add(index, child);
    }

    public void removeChild(JarEntry child) {
        this.children.remove(child);
    }

    public ImageIcon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (this.type != JarEntryType.fileEntry) {
            return this.type.getIcon();
        }
        ImageIcon icon = FileUtils.getStandardFileIcon(false, this.getEntryExtension(), 1.0f);
        if (icon != null) {
            return icon;
        }
        return JarEntryType.fileEntry.getIcon();
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getEntryExtension() {
        return FileUtils.getFileExtPart(this.name, false);
    }

    public boolean isClassEntry(Class classType) {
        return classType != null && classType.getCanonicalName().equals(this.getCanonicalEntryName());
    }

    public String getCanonicalEntryName() {
        StringBuilder canonicalName = new StringBuilder(this.getName());
        for (JarEntry parent = this.getParent(); parent != null && !parent.getType().equals((Object)JarEntryType.jarEntry); parent = parent.getParent()) {
            canonicalName.insert(0, parent.getName() + ".");
        }
        if (this.type.equals((Object)JarEntryType.classEntry) || this.type.equals((Object)JarEntryType.javaEntry)) {
            canonicalName = new StringBuilder(canonicalName.substring(0, canonicalName.lastIndexOf(".")));
        }
        return canonicalName.toString();
    }

    public String getCanonicalEntryPath() {
        StringBuilder canonicalName = new StringBuilder(this.getName());
        for (JarEntry parent = this.getParent(); parent != null && !parent.getType().equals((Object)JarEntryType.jarEntry) && !parent.getParent().getType().equals((Object)JarEntryType.jarEntry); parent = parent.getParent()) {
            canonicalName.insert(0, parent.getName() + "/");
        }
        return canonicalName.toString();
    }

    public List<JarEntry> getPath() {
        ArrayList<JarEntry> path = new ArrayList<JarEntry>();
        for (JarEntry current = this; current != null && !current.getType().equals((Object)JarEntryType.jarEntry); current = current.getParent()) {
            path.add(0, current);
        }
        return path;
    }

    public InputStream getInputStream() {
        try {
            return new ZipFile(this.structure.getJarLocation()).getInputStream(this.getZipEntry());
        }
        catch (IOException e) {
            LoggerFactory.getLogger(JarEntry.class).error(e.toString(), (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof JarEntry && ((JarEntry)obj).getCanonicalEntryPath().equals(this.getCanonicalEntryPath());
    }

    public String toString() {
        return this.getName() + " (" + (Object)((Object)this.getType()) + ")";
    }
}

