/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.map;

import com.alee.utils.MapUtils;
import com.alee.utils.collection.ImmutableCollection;
import com.alee.utils.collection.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImmutableMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    protected final HashMap<K, V> data;

    public ImmutableMap(Object ... data) {
        this.data = MapUtils.newHashMap(data);
    }

    public ImmutableMap(Map<K, V> map) {
        this.data = new HashMap<K, V>(map);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.data.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw this.createModificationException();
    }

    @Override
    public V remove(Object key) {
        throw this.createModificationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw this.createModificationException();
    }

    @Override
    public void clear() {
        throw this.createModificationException();
    }

    @Override
    public Set<K> keySet() {
        return new ImmutableSet<K>(this.data.keySet());
    }

    @Override
    public Collection<V> values() {
        return new ImmutableCollection<V>(this.data.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ImmutableSet<Map.Entry<K, V>>(this.data.entrySet());
    }

    protected UnsupportedOperationException createModificationException() {
        return new UnsupportedOperationException("Map is unmodifiable");
    }
}

