/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

import com.alee.utils.ReflectUtils;
import com.alee.utils.reflection.ReflectionException;

public final class LazyInstance<T> {
    private final Class<? extends T> clazz;
    private final Object[] arguments;
    private T instance;

    public LazyInstance(Class<? extends T> clazz, Object ... arguments) {
        this.clazz = clazz;
        this.arguments = arguments;
    }

    public T create() {
        try {
            return ReflectUtils.createInstance(this.clazz, this.arguments);
        }
        catch (Exception e) {
            String msg = "Unable to instantiate skin for class: %s";
            throw new ReflectionException(String.format("Unable to instantiate skin for class: %s", this.clazz), e);
        }
    }

    public synchronized T get() {
        if (this.instance == null) {
            this.instance = this.create();
        }
        return this.instance;
    }
}

